% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_listing.R
\name{tbl_listing}
\alias{tbl_listing}
\alias{remove_duplicate_keys}
\title{Create listings from a data frame}
\usage{
tbl_listing(
  data,
  split_by_rows = list(),
  split_by_columns = list(),
  add_blank_rows = list()
)

remove_duplicate_keys(x, keys = NULL, value = NA)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame containing the data to be displayed in the listing.}

\item{split_by_rows, split_by_columns, add_blank_rows}{(named \code{list})\cr
\itemize{
\item \code{split_by_rows}: Named list of arguments that are passed to \code{gtsummary::tbl_split_by_rows()}.
\item \code{split_by_columns}: Named list of arguments that are passed to \code{gtsummary::tbl_split_by_columns()}.
\item \code{add_blank_rows}: Named list of arguments that are passed to \code{crane::add_blank_rows()}.
\code{add_blank_rows()} is applied after table splitting and applied to each table individually.
}

\emph{Variable names passed in these named lists must be character vectors; tidyselect/unquoted syntax is not accepted.}}

\item{x}{(\code{tbl_listing} or \code{list})\cr
a \code{tbl_listing} object or a list of \code{tbl_listing} objects.}

\item{keys}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to highlight for duplicate values. If \code{NULL}, nothing is done.}

\item{value}{(\code{string})\cr
string to use for blank values. Defaults to \code{NA}. It should not be changed.}
}
\description{
This function creates a listing from a data frame. Common uses
rely on few pre-processing steps, such as ensuring unique values in key columns or split
by rows or columns. They are described in the note section.
}
\note{
Common pre-processing steps for the data frame that may be common:
\itemize{
\item Unique values - this should be enforced in pre-processing by users.
\item \code{NA} values - they are not printed by default in \code{{gtsummary}}. You can make them explicit if
they need to be displayed in the listing. See example 3.
\item Sorting key columns and moving them to the front. See the examples pre-processing.
}
\subsection{Splitting the listing}{
\itemize{
\item Split by rows - you can split the data frame by rows by using \code{split_by_rows} parameter. You can use the same
parameters used in \code{\link[gtsummary:tbl_split_by]{gtsummary::tbl_split_by_rows()}}. See example 4.
\item Split by columns - you can split the data frame by columns by using \code{split_by_columns} parameter. Use the same
parameters from \code{\link[gtsummary:tbl_split_by]{gtsummary::tbl_split_by_rows()}}. See example 5.
}
}
}
\examples{
\dontshow{if (crane:::is_pkg_installed("labelled")) withAutoprint(\{ # examplesIf}
# Load the trial dataset
trial_data <- trial |>
  dplyr::select(trt, age, marker, stage) |>
  dplyr::filter(stage \%in\% c("T2", "T3")) |>
  dplyr::slice_head(n = 2, by = c(trt, stage)) |> # downsampling
  dplyr::arrange(trt, stage) |> # key columns should be sorted
  dplyr::relocate(trt, stage) # key columns should be first

# Example 1 --------------------------------
out <- tbl_listing(trial_data)
out
out |> remove_duplicate_keys(keys = "trt")

# Example 2 --------------------------------
# make NAs explicit
trial_data_na <- trial_data |>
  mutate(across(everything(), ~ tidyr::replace_na(labelled::to_character(.), "-")))
tbl_listing(trial_data_na)

# Example 3 --------------------------------
# Add blank rows for first key column
lst <- tbl_listing(trial_data_na, add_blank_rows = list(variable_level = "trt"))
lst

# Can add them also manually in post-processing
lst |> add_blank_rows(row_numbers = seq(2))

# Example 4 --------------------------------
# Split by rows
list_lst <- tbl_listing(trial_data, split_by_rows = list(row_numbers = c(2, 3, 4)))
list_lst[[2]]

# Example 5 --------------------------------
# Split by columns
show_header_names(lst)
grps <- list(c("trt", "stage", "age"), c("trt", "stage", "marker"))
list_lst <- tbl_listing(trial_data, split_by_columns = list(groups = grps))
list_lst[[2]]

# Example 6 --------------------------------
# Split by rows and columns
list_lst <- tbl_listing(trial_data,
  split_by_rows = list(row_numbers = c(2, 3, 4)), split_by_columns = list(groups = grps)
)
length(list_lst) # 8 tables are flatten out
list_lst[[2]]

# Example 7 --------------------------------
# Hide duplicate columns in post-processing
out <- list_lst |>
  remove_duplicate_keys(keys = c("trt", "stage"))
out[[2]]
\dontshow{\}) # examplesIf}
}
