% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_model.R
\name{set_model}
\alias{set_model}
\title{Cram Policy: Set Model}
\usage{
set_model(model_type, learner_type, model_params)
}
\arguments{
\item{model_type}{The model type for policy learning. Options include \code{"causal_forest"}, \code{"s_learner"}, and \code{"m_learner"}. Default is \code{"causal_forest"}. Note: you can also set model_type to NULL and specify custom_fit and custom_predict to use your custom model.}

\item{learner_type}{The learner type for the chosen model. Options include \code{"ridge"} for Ridge Regression, \code{"fnn"} for Feedforward Neural Network and \code{"caret"} for Caret. Default is \code{"ridge"}. if model_type is 'causal_forest', choose NULL, if model_type is 's_learner' or 'm_learner', choose between 'ridge', 'fnn' and 'caret'.}

\item{model_params}{A list of additional parameters to pass to the model, which can be any parameter defined in the model reference package. Defaults to \code{NULL}.
For FNNs, the following elements are defined in the model params list:
\describe{
  \item{\code{input_layer}}{A list defining the input layer. Must include:
    \describe{
      \item{\code{units}}{Number of units in the input layer.}
      \item{\code{activation}}{Activation function for the input layer.}
      \item{\code{input_shape}}{Input shape for the layer.}
    }
  }
  \item{\code{layers}}{A list of lists, where each sublist specifies a hidden layer with:
    \describe{
      \item{\code{units}}{Number of units in the layer.}
      \item{\code{activation}}{Activation function for the layer.}
    }
  }
  \item{\code{output_layer}}{A list defining the output layer. Must include:
    \describe{
      \item{\code{units}}{Number of units in the output layer.}
      \item{\code{activation}}{Activation function for the output layer (e.g., \code{"linear"} or \code{"sigmoid"}).}
    }
  }
  \item{\code{compile_args}}{A list of arguments for compiling the model. Must include:
    \describe{
      \item{\code{optimizer}}{Optimizer for training (e.g., \code{"adam"} or \code{"sgd"}).}
      \item{\code{loss}}{Loss function (e.g., \code{"mse"} or \code{"binary_crossentropy"}).}
      \item{\code{metrics}}{Optional list of metrics for evaluation (e.g., \code{c("accuracy")}).}
    }
  }
}
For other learners (e.g., \code{"ridge"} or \code{"causal_forest"}), \code{model_params} can include relevant hyperparameters.}
}
\value{
The instantiated model object or the corresponding model function.
}
\description{
This function maps the model type and learner type to the corresponding model function.
}
