% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cragg.R
\name{cragg_donald}
\alias{cragg_donald}
\title{Calculate the Cragg-Donald statistic for a given model.}
\usage{
cragg_donald(X, D, Z, data = data.frame())
}
\arguments{
\item{X}{(formula). A one-sided formula of control variables.}

\item{D}{(formula). A one-sided formula of endogenous variables (treatments)}

\item{Z}{(formula). A one-sided formula of instruments}

\item{data}{(dataframe). An optional dataframe, list, or environment
containing the variables used in the model. As with many of the base R
functions, if the variables are not found here, they may be searched for in
the environment cragg_donald() was called.}
}
\value{
(cd_test) results object of class "cd_test"
}
\description{
Calculate the Cragg-Donald statistic for a given model.
}
\examples{
#Obtain the Cragg-Donald statistic for a model that instruments
#Sepal Width on Petal Length, Petal Width, and Species, while controlling
#for Sepal.Length (a toy example).
cragg_donald(X=~Sepal.Length, D=~Sepal.Width,
			Z=~Petal.Length + Petal.Width + Species, data = iris)
}
