% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dctp.R, R/pctp.R, R/qctp.R, R/rctp.R
\name{ebw}
\alias{ebw}
\alias{debw}
\alias{pebw}
\alias{qebw}
\alias{rebw}
\title{The Extended Biparametric Waring (EBW) Distribution}
\usage{
debw(x, alpha, gamma, rho)

pebw(q, alpha, gamma, rho, lower.tail = TRUE)

qebw(p, alpha, gamma, rho, lower.tail = TRUE)

rebw(n, alpha, gamma, rho, lower.tail = TRUE)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{alpha}{parameter alpha (real)}

\item{gamma}{parameter \eqn{\gamma} (positive)}

\item{rho}{parameter rho (positive)}

\item{q}{vector of quantiles.}

\item{lower.tail}{if TRUE (default), probabilities are \eqn{P(X<=x)}, otherwise, \eqn{P(X>x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{debw} gives the pmf, \code{pebw} gives the distribution function, \code{qebw} gives the quantile function and \code{rebw} generates random values.																																	

If \eqn{\alpha > 0} the probability mass function, distribution function, quantile function and random generation function for the UGW\eqn{(\alpha,\alpha,\rho)} distribution arise.

If \eqn{\alpha < 0} the probability mass function, distribution function, quantile function and random generation function for the CTP\eqn{(\alpha,0,\gamma)} distribution arise.
}
\description{
Probability mass function, distribution function, quantile function and random generation for the Extended Biparametric Waring (EBW) distribution with parameters \eqn{\alpha} and \eqn{\gamma} (or \eqn{\rho}).
}
\details{
The EBW distribution with parameters \eqn{\alpha} and \eqn{\gamma} has pmf
\deqn{f(x|a,\alpha,\gamma) = C \Gamma(\alpha+x)^2 / (\Gamma(\gamma+x) x!), x=0,1,2,...} 
where \eqn{\Gamma(·)} is the gamma function and 
\deqn{C = \Gamma(\gamma-\alpha^2 / (\Gamma(\alpha)^2 \Gamma(\gamma-2a))}
the normalizing constant.

There is an alternative parametrization in terms of \eqn{\alpha} and \eqn{\rho=\gamma-2\alpha>0} 
when \eqn{\alpha>0}. So, introduce only \eqn{\alpha} and \eqn{\gamma} or \eqn{\alpha} and \eqn{\rho},
depending on the parametrization you wish to use.


The mean and the variance of the EBW distribution are
\eqn{E(X)=\mu=\alpha^2/(\gamma-2\alpha-1)} and \eqn{Var(X)=\mu(\mu+\gamma-1)/(\gamma-2\alpha-2)}
so \eqn{\gamma > 2a + 2}.

It is underdispersed if \eqn{\alpha < - (\mu + 1) / 2}, equidispersed if \eqn{\alpha = - (\mu + 1) / 2} or overdispersed
if \eqn{\alpha > - (\mu + 1) / 2}. In particular, if \eqn{\alpha >= -0.5} the EBW is overdispersed, whereas if 
\eqn{\alpha < -1} the EBW is underdispersed. In the case \eqn{-1 < \alpha <= -0.5}, the EBW may be under-, equi- or 
overdispersed depending on the value of \eqn{\gamma}.
}
\examples{
# Examples for the function dctp
debw(3,1,rho=5)
debw(c(3,4),2,rho=5)

# Examples for the function pebw
pebw(3,2,rho=5)
pebw(c(3,4),2,rho=5)

# Examples for the function qebw
qebw(0.5,-2.1,gamma=0.1)
qebw(c(.8,.9),-2.1,gamma=0.1)
qebw(0.5,2,rho=5)
qebw(c(.8,.9),2,rho=5)

# Examples for the function rebw
rebw(10,2,rho=5)
rebw(10,-2.1,gamma=5)

}
\references{
\insertRef{RCS2003}{cpd}

\insertRef{RCSO2004}{cpd}

\insertRef{ROC2018}{cpd}
}
\seealso{
Functions for maximum-likelihood fitting of the CTP and CBP distributions: \code{\link{fitctp}} and \code{\link{fitcbp}}.
}
