% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coveR2-package.R, R/coveR2.R
\docType{package}
\name{coveR2}
\alias{coveR2}
\alias{coveR2-package}
\title{coveR2: Process Digital Cover Photography Images of Tree Crowns}
\usage{
coveR2(
  filename,
  channel = 3,
  thdmethod = "Otsu",
  gapmethod = "macfarlane",
  thd = 1.3/100,
  k = 0.5,
  crop = NULL,
  export.image = FALSE,
  display = TRUE,
  message = TRUE
)
}
\arguments{
\item{filename}{Character. The input image filename}

\item{channel}{Integer. The band number corresponding to the blue channel. Default value is 3}

\item{thdmethod}{Character. The method used to threshold the image, using the \code{\link[autothresholdr:auto_thresh]{autothresholdr::auto_thresh()}} function. For details, see \url{https://imagej.net/plugins/auto-threshold}. Default = 'Otsu'.}

\item{gapmethod}{Character. The method used to classify large and small gaps. Default = 'macfarlane'}

\item{thd}{Numeric. The large gap threshold, as a function of the image size. Used only when method = 'macfarlane'. Default = 1.3/100}

\item{k}{Numeric The extinction coefficient at the zenith. Default is 0.5 (spherical leaf angle distribution)}

\item{crop}{Integer. The number of lines to be removed from the bottom side of the image. Useful to remove the 'timestamp' watermark in camera traps.}

\item{export.image}{Logical. It allows exporting an image of the classified gaps}

\item{display}{Logical. It allows displaying the result of image classification.}

\item{message}{Logical. It allows displaying messages.}
}
\description{
Process Digital Cover Photography images of tree canopies to get canopy attributes like Foliage Cover and Leaf Area Index. Detailed description of the methods in \doi{10.1007/s00468-018-1666-3}.

The function calculates all the image processing steps and
returns the output canopy attributes. It is also possible to export the classified image.
}
\examples{
image <- file.path(system.file(package='coveR2'), 'extdata/IMG1.JPG')
res<-coveR2(image, gapmethod='macfarlane',thd=0.5/100, k=0.65)
res
}
\author{
\strong{Maintainer}: Francesco Chianucci \email{fchianucci@gmail.com} (\href{https://orcid.org/0000-0002-5688-2060}{ORCID})

Authors:
\itemize{
  \item Nicola Puletti \email{nicola.puletti@gmail.com} (\href{https://orcid.org/0000-0002-2142-959X}{ORCID})
  \item Carlotta Ferrara \email{carlottaferrara@gmail.com} (\href{https://orcid.org/0000-0001-5249-1196}{ORCID})
}

}
\keyword{internal}
