% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costprop.R
\name{cost.proportionate.classifier}
\alias{cost.proportionate.classifier}
\title{Cost-Proportionate Classifier}
\usage{
cost.proportionate.classifier(X, y, weights, classifier, nsamples = 10,
  extra_rej_const = 0.1, nthreads = 1, seed = 1, ...)
}
\arguments{
\item{X}{Features/Covariates for each observation.}

\item{y}{Class for each observation.}

\item{weights}{Weights for each observation.}

\item{classifier}{Base classifier to use.}

\item{nsamples}{Number of resamples to take.}

\item{extra_rej_const}{Extra rejection constant - the higher, the smaller each sample ends up being,
but the smallest the chance that the highest-weighted observations would end up in each sample.}

\item{nthreads}{Number of parallel threads to use (not available on Windows systems). Note
that, unlike the Python version, this is not a shared memory model and each additional thread will
require more memory from the system. Not recommended to use when the algorithm is itself parallelized.}

\item{seed}{Random seed to use for the random number generation.}

\item{...}{Additional arguments to pass to `classifier`.}
}
\description{
Fits a classifier with sample weights by reducing the problem to classification
without sample weights through rejection sampling.
}
\examples{
\dontrun{
### example here requires 'caret' package
library(costsensitive)
data(iris)
set.seed(1)
X <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
y <- factor(iris$Species == "setosa", labels = c("class1", "class2"))
weights <- rgamma(100, 1)
classifier <- caret::train
model <- cost.proportionate.classifier(X, y, weights, classifier,
  method = "glm", family = "binomial",
  trControl=caret::trainControl(method="none"), tuneLength=1)
predict(model, X, aggregation = "raw", type = "raw")
predict(model, X, aggregation = "weighted", type = "prob")
}
}
\references{
Beygelzimer, A., Langford, J., & Zadrozny, B. (2008). Machine learning techniques-reductions between prediction quality metrics.
}
