% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{matrix_via_r}
\alias{matrix_via_r}
\title{Create document term matrix for fast search of single words}
\usage{
matrix_via_r(df, matrix_without_punctuation = TRUE)
}
\arguments{
\item{df}{A "data_dok" tibble}

\item{matrix_without_punctuation}{Should punctuation and digits be stripped
  from the text before constructing the document term matrix? If \code{TRUE},
  the default:
\itemize{
    \item The corporaexplorer object will be lighter and most searches in
    the corpus exploration app will be faster.
    \item Searches including punctuation and digits will be carried out in
    the full text documents.
    \item The only "risk" with this strategy is that the corpus exploration
    app in some cases can produce false positives. E.g. searching for the
    term "donkey" will also find the term "don\%key".
This should not be a problem for the vast majority of use cases, but if
one so desires, there are three different solutions: set this parameter to
\code{FALSE}, create a corporaexplorerobject without a matrix by setting
the \code{use_matrix} parameter to \code{FALSE}, or run
\code{\link[corporaexplorer]{explore}} with the
\code{use_matrix} parameter set to \code{FALSE}.
}
 If \code{FALSE}, the corporaexplorer object will be larger, and most
 simple searches will be slower.}
}
\value{
List: 1) Document term matrix (data.table), 2) word vector (character
  vector).
}
\description{
The characters removed
}
\keyword{internal}
