% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_deaths.R
\name{country_dead}
\alias{country_dead}
\title{Plot country deaths by week, with various adjustments:}
\usage{
country_dead(country = "England+Wales", pdf = FALSE, save = FALSE)
}
\arguments{
\item{country}{Country name}

\item{pdf}{default FALSE will not print to PDF}

\item{save}{Do we save the data as a CSV}
}
\description{
Assumes the existence of the data frame stmf containing relevant iso_codes for countries.
The unusual codes GBRTENW and GBR_SCO represent England+Wales and Scotland.
You can obtain a list of countries by country_dead('?'), forcing a diagnostic error!
}
\details{
The columns in the frame stmf are just 'iso_code', 'Year', 'Week', and 'Deaths'.

Draws three graphs:
\enumerate{
\item Raw data with a linear regression line, over n years;
\item Data with secular adjustment;
\item Data adjusted for a 'summer baseline' using the "other n years of data" after
secular adjustment.
}
}
\examples{
country_dead( 'New Zealand' ) 
}
\keyword{corona}
\keyword{deaths}
