% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_measurements.R
\name{set_measurements}
\alias{set_measurements}
\title{Convert columns with measurement data for an individual or event to Darwin Core standard}
\usage{
set_measurements(.df, cols = NULL, unit = NULL, type = NULL, .keep = "unused")
}
\arguments{
\item{.df}{a \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{cols}{vector of column names to be included as 'measurements'. Unquoted.}

\item{unit}{vector of strings giving units for each variable}

\item{type}{vector of strings giving a description for each variable}

\item{.keep}{Control which columns from .data are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core fields, and not those fields used to
generate them.}
}
\value{
A tibble with the requested fields added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function is a work in progress, and should be used with caution.

In raw collected data, many types of information can be captured in one
column. For example, the column name \code{LMA_g.m2} contains the measured trait
(Leaf Mass per Area, LMA) and the unit of measurement (grams per meter
squared, g/m2), and recorded in that column are the values themselves. In
Darwin Core, these different types of information must be separated into
multiple columns so that they can be ingested correctly and aggregated with
sources of data accurately.

This function converts information preserved in a single measurement column
into multiple columns (\code{measurementID}, \code{measurementUnit}, and
\code{measurementType}) as per Darwin Core standard.
}
\details{
Columns are nested in a
single column \code{measurementOrFact} that contains Darwin Core Standard
measurement fields. By nesting three measurement columns within the
\code{measurementOrFact} column, nested measurement columns can be converted to
long format (one row per measurement, per occurrence) while the original
data frame remains organised by one row per occurrence. Data
can be unnested into long format using \code{\link[tidyr:unnest]{tidyr::unnest()}}.
}
\examples{
\donttest{
library(tidyr)

# Example data of plant species observations and measurements
df <- tibble::tibble(
  Site = c("Adelaide River", "Adelaide River", "AgnesBanks"),
  Species = c("Corymbia latifolia", "Banksia aemula", "Acacia aneura"),
  Latitude = c(-13.04, -13.04, -33.60),
  Longitude = c(131.07, 131.07, 150.72),
  LMA_g.m2 = c(NA, 180.07, 159.01),
  LeafN_area_g.m2 = c(1.100, 0.913, 2.960)
)

# Reformat columns to Darwin Core Standard
# Measurement columns are reformatted and nested in column `measurementOrFact`
df_dwc <- df |>
  set_measurements(
    cols = c(LMA_g.m2,
             LeafN_area_g.m2),
    unit = c("g/m2",
             "g/m2"),
    type = c("leaf mass per area",
             "leaf nitrogen per area")
  )

df_dwc

# Unnest to view full long format data frame
df_dwc |>
  tidyr::unnest(measurementOrFact)

}
}
