% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corazon_gradient.R
\name{corazon_gradient}
\alias{corazon_gradient}
\title{Display a linear gradient color within shiny elements}
\usage{
corazon_gradient(
  element = "body",
  direction = "right",
  colorName = "LIFE",
  txtColor = "#F2F2F2"
)
}
\arguments{
\item{element}{the shiny element that will incorporate the gradient color ? Defaults to "body"}

\item{direction}{the direction of the gradient, between "right", "left", "bottom", "top". Defaults to "right"}

\item{colorName}{the name of the gradient color to apply. see \url{https://www.colorffy.com/gradients/catalog}}

\item{txtColor}{the text color. Default to "#F2F2F2" (white)}
}
\value{
A linear gradient color applied on a specific shiny element
}
\description{
Display a linear gradient color within shiny elements
}
\examples{

if(interactive()){

ui <- fluidPage(


corazon_gradient(txtColor = "blue"),


h1("This is a Title"),

)

server <- function(input, output) {

}

# Run the application


shinyApp(ui = ui, server = server)

}




}
