% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{NSconvo_fit}
\alias{NSconvo_fit}
\title{Fit the nonstationary spatial model}
\usage{
NSconvo_fit(
  sp.SPDF = NULL,
  coords = NULL,
  data = NULL,
  cov.model = "exponential",
  mean.model = data ~ 1,
  mc.locations = NULL,
  N.mc = NULL,
  lambda.w = NULL,
  fixed.nugg2.var = NULL,
  mean.model.df = NULL,
  mc.kernels = NULL,
  fit.radius = NULL,
  ns.nugget = FALSE,
  ns.variance = FALSE,
  ns.mean = FALSE,
  local.aniso = TRUE,
  fix.tausq = FALSE,
  tausq = 0,
  fix.kappa = FALSE,
  kappa = 0.5,
  method = "reml",
  print.progress = TRUE,
  local.pars.LB = NULL,
  local.pars.UB = NULL,
  global.pars.LB = NULL,
  global.pars.UB = NULL,
  local.ini.pars = NULL,
  global.ini.pars = NULL
)
}
\arguments{
\item{sp.SPDF}{A "\code{SpatialPointsDataFrame}" object, which contains the
spatial coordinates and additional attribute variables corresponding to the
spatoal coordinates}

\item{coords}{An N x 2 matrix where each row has the two-dimensional
coordinates of the N data locations.}

\item{data}{A vector or matrix with N rows, containing the data values.
Inputting a vector corresponds to a single replicate of data, while
inputting a matrix corresponds to replicates. In the case of replicates,
the model assumes the replicates are independent and identically
distributed.}

\item{cov.model}{A string specifying the model for the correlation
function; defaults to \code{"exponential"}.
Options available in this package are: "\code{exponential}",
\code{"matern"}, and \code{"gaussian"}.}

\item{mean.model}{An object of class \code{\link[stats]{formula}},
specifying the mean model to be used. Defaults to an intercept only.}

\item{mc.locations}{Optional; matrix of mixture component locations.}

\item{N.mc}{Optional; if \code{mc.locations} is not specified, the
function will create a rectangular grid of size \code{N.mc} over the
spatial domain.}

\item{lambda.w}{Scalar; tuning parameter for the weight function.
Defaults to be the square of one-half of the minimum distance between
mixture component locations.}

\item{fixed.nugg2.var}{Optional; describes the variance/covariance for
a fixed (second) nugget term (represents a known error term). Either
a vector of length N containing a station-specific variances (implying
independent error) or an NxN covariance matrix (implying dependent error).
Defaults to zero.}

\item{mean.model.df}{Optional data frame; refers to the variables used
in \code{mean.model}. Important when using categorical variables in
\code{mean.model}, as a subset of the full design matrix will likely
be rank deficient. Specifying \code{mean.model.df} allows \code{NSconvo_fit}
to calculate a design matrix specific to the points used to fit each
local model.}

\item{mc.kernels}{Optional specification of mixture component kernel
matrices (based on expert opinion, etc.).}

\item{fit.radius}{Scalar; specifies the fit radius or neighborhood size
for the local likelihood estimation.}

\item{ns.nugget}{Logical; indicates if the nugget variance (tausq) should
be spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}

\item{ns.variance}{Logical; indicates if the process variance (sigmasq)
should be spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}

\item{ns.mean}{Logical; indicates if the mean coefficeints (beta)
should be spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}

\item{local.aniso}{Logical; indicates if the local covariance should be
anisotropic (\code{TRUE}) or isotropic (\code{FALSE}). Defaults to \code{TRUE}.
In the case of a locally isotropic model, the bounds and initial values
for lam will default to the first element of \code{local.pars.LB},
\code{local.pars.UB}, and \code{local.ini.pars} (while still required, the
second and third elements of these vectors will be ignored.)}

\item{fix.tausq}{Logical; indicates whether the default nugget term
(tau^2) should be fixed (\code{TRUE}) or estimated (\code{FALSE}). Defaults to
\code{FALSE}.}

\item{tausq}{Scalar; fixed value for the nugget variance (when
\code{fix.tausq = TRUE}).}

\item{fix.kappa}{Logical; indicates if the kappa parameter should be
fixed (\code{TRUE}) or estimated (\code{FALSE}). Defaults to \code{FALSE}
(only valid for \code{cov.model = "matern"} and \code{cov.model = "cauchy"}).}

\item{kappa}{Scalar; value of the kappa parameter. Only used if
\code{fix.kappa = TRUE}.}

\item{method}{Indicates the estimation method, either maximum likelihood
(\code{"ml"}) or restricted maximum likelihood (\code{"reml"}).}

\item{print.progress}{Logical; if \code{TRUE}, text indicating the progress
of local model fitting in real time.}

\item{local.pars.LB, local.pars.UB}{Optional vectors of lower and upper
bounds, respectively, used by the \code{"L-BFGS-B"} method option in the
\code{\link[stats]{optim}} function for the local parameter estimation.
Each vector must be of length five,
containing values for lam1, lam2, tausq, sigmasq, and nu. Default for
\code{local.pars.LB} is \code{rep(1e-05,5)}; default for
\code{local.pars.UB} is \code{c(max.distance/2, max.distance/2, 4*resid.var, 4*resid.var, 100)},
where \code{max.distance} is the maximum interpoint distance of the
observed data and \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{global.pars.LB, global.pars.UB}{Optional vectors of lower and upper
bounds, respectively, used by the \code{"L-BFGS-B"} method option in the
\code{\link[stats]{optim}} function for the global parameter estimation.
Each vector must be of length three,
containing values for tausq, sigmasq, and nu. Default for
\code{global.pars.LB} is \code{rep(1e-05,3)}; default for
\code{global.pars.UB} is \code{c(4*resid.var, 4*resid.var, 100)},
where \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{local.ini.pars}{Optional vector of initial values used by the
\code{"L-BFGS-B"} method option in the \code{\link[stats]{optim}}
function for the local parameter estimation. The vector must be of length
five, containing values for lam1, lam2, tausq, sigmasq, and nu. Defaults
to \code{c(max.distance/10, max.distance/10, 0.1*resid.var, 0.9*resid.var, 1)},
where \code{max.distance} is the maximum interpoint distance of the
observed data and \code{resid.var} is the residual variance from using
\code{\link[stats]{lm}} with \code{mean.model}.}

\item{global.ini.pars}{Optional vector of initial values used by the
\code{"L-BFGS-B"} method option in the \code{\link[stats]{optim}}
function for the global parameter estimation. The vector must be of length
three, containing values for tausq, sigmasq, and nu. Defaults to
\code{c(0.1*resid.var, 0.9*resid.var, 1)}, where \code{resid.var} is the
residual variance from using \code{\link[stats]{lm}} with \code{mean.model}.}
}
\value{
A "NSconvo" object, with the following components:
\item{mc.locations}{Mixture component locations used for the simulated
data.}
\item{mc.kernels}{Mixture component kernel matrices used for the simulated
data.}
\item{MLEs.save}{Table of local maximum likelihood estimates for each
mixture component location.}
\item{kernel.ellipses}{\code{N.obs} x 2 x 2 array, containing the kernel
matrices corresponding to each of the simulated values.}
\item{data}{Observed data values.}
\item{beta.GLS}{Generalized least squares estimates of beta,
the mean coefficients. For \code{ns.mean = FALSE}, this is a vector
(containing the global mean coefficients); for \code{ns.mean = TRUE},
this is a matrix (one column for each mixture component location).}
\item{beta.cov}{Covariance matrix of the generalized least squares
estimate of beta. For \code{ns.mean = FALSE}, this is a matrix
(containing the covariance of theglobal mean coefficients); for
\code{ns.mean = TRUE}, this is an array (one matrix for each mixture
component location).}
\item{Mean.coefs}{"Regression table" for the mean coefficient estimates,
listing the estimate, standard error, and t-value (for \code{ns.mean =
FALSE} only).}
\item{tausq.est}{Estimate of tausq (nugget variance), either scalar (when
\code{ns.nugget = "FALSE"}) or a vector of length N (when
\code{ns.nugget = "TRUE"}), which contains the estimated nugget variance
for each observation location.}
\item{sigmasq.est}{Estimate of sigmasq (process variance), either scalar
(when \code{ns.variance = "FALSE"}) or a vector of length N (when
\code{ns.variance = "TRUE"}), which contains the estimated process
variance for each observation location.}
\item{beta.est}{Estimate of beta (mean coefficients), either a vector
(when \code{ns.mean = "FALSE"}) or a matrix with N rows (when
\code{ns.mean = "TRUE"}), each row of which contains the estimated
(smoothed) mean coefficients for each observation location.}
\item{kappa.MLE}{Scalar maximum likelihood estimate for kappa (when
applicable).}
\item{Cov.mat}{Estimated covariance matrix (\code{N.obs} x \code{N.obs})
using all relevant parameter estimates.}
\item{Cov.mat.chol}{Cholesky of \code{Cov.mat} (i.e., \code{chol(Cov.mat)}),
the estimated covariance matrix (\code{N.obs} x \code{N.obs}).}
\item{cov.model}{String; the correlation model used for estimation.}
\item{ns.nugget}{Logical, indicating if the nugget variance was estimated
as spatially-varing (\code{TRUE}) or constant (\code{FALSE}).}
\item{ns.variance}{Logical, indicating if the process variance was
estimated as spatially-varying (\code{TRUE}) or constant (\code{FALSE}).}
\item{fixed.nugg2.var}{N x N matrix with the fixed
variance/covariance for the second (measurement error) nugget term (defaults
to zero).}
\item{coords}{N x 2 matrix of observation locations.}
\item{global.loglik}{Scalar value of the maximized likelihood from the
global optimization (if available).}
\item{Xmat}{Design matrix, obtained from using \code{\link[stats]{lm}}
with \code{mean.model}.}
\item{lambda.w}{Tuning parameter for the weight function.}
\item{fix.kappa}{Logical, indicating if kappa was fixed (\code{TRUE}) or
estimated (\code{FALSE}).}
\item{kappa}{Scalar; fixed value of kappa.}
}
\description{
\code{NSconvo_fit} estimates the parameters of the nonstationary
convolution-based spatial model. Required inputs are the observed data and
locations. Optional inputs include mixture component locations (if not provided,
the number of mixture component locations are required), the fit radius,
the covariance model (exponential is the default), and whether or not the
nugget and process variance will be spatially-varying.
}
\examples{
\dontrun{
# Using white noise data
fit.model <- NSconvo_fit( coords = cbind( runif(100), runif(100)),
data = rnorm(100), fit.radius = 0.4, N.mc = 4 )
}

}
