% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads_utilities.R
\name{compare_sim_meas}
\alias{compare_sim_meas}
\title{Compare multiple similarity measures}
\usage{
compare_sim_meas(similarity_list, measure_names)
}
\arguments{
\item{similarity_list}{A list of lists, where each inner list contains similarities for each dyad}

\item{measure_names}{A vector of names for each similarity measure}
}
\value{
A data frame with all similarity measures for each dyad
}
\description{
This function compares multiple similarity measures for the same set of dyads.
}
\examples{
topic_similarities <- list("1" = c(0.5, 0.6, 0.7), "2" = c(0.4, 0.5, 0.6))
lexical_similarities <- list("1" = c(0.6, 0.7, 0.8), "2" = c(0.5, 0.6, 0.7))
compare_sim_meas(
  list(topic_similarities, lexical_similarities),
  c("Topic", "Lexical")
)
print(plot)
}
