% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreb_yrs.R
\name{scoreb_yrs}
\alias{scoreb_yrs}
\title{Scoreboard of countries}
\usage{
scoreb_yrs(myTB, timeName = "time")
}
\arguments{
\item{myTB}{original complete dataset (tibble) time by country,
ordered by time; only time and countries variables must be present,
no average or auxiliary variables at all.
Only years of interest must be present and only countries
contributing to the average of each year.}

\item{timeName}{string with the name of the time variable in myTB}
}
\value{
list of tibbles containing   departures and integer labels. Integer
         values in the result refers to the partition
         (-Inf, m-1 s, m-0.5 s, m+0.5 s, m+1 s, Inf) where m is the average
         and s the standard deviation at a given time t; in particular
         the ordinal is 1 if the interval (-Inf, m -1 s) contains the indicator,
         it is 2 if the interval ( m-1 s, m-0.5 s) contains the indicator, and so on
         up to the value 5 that means an indicator value above m + 1 s.
}
\description{
A scoreboard of countries shows the departure of an indicator level
from the average, for each year in the dataset.
It also considers one-year changes and the inherent average (and departure)
for  each year.
}
\examples{

# Example 1
# Dataset in the format years by countries:
require(tibble)
testTB <- dplyr::tribble(
    ~time, ~countryA ,  ~countryB,  ~countryC,
    2000,     0.8,   2.7,    3.9,
    2001,     1.2,   3.2,    4.2,
    2002,     0.9,   2.9,    4.1,
    2003,     1.3,   2.9,    4.0,
    2004,     1.2,   3.1,    4.1,
    2005,     1.2,   3.0,    4.0
    )
resTB1<-scoreb_yrs(testTB, timeName = "time")

# Example 2
# Scoreboard of countries for the emp_20_64_MS Eurofound dataset:
data("emp_20_64_MS")
resTB2 <- scoreb_yrs(emp_20_64_MS,timeName = "time")

}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
