% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_ranking.R
\name{country_ranking}
\alias{country_ranking}
\title{Ranking of EU countries by time}
\usage{
country_ranking(
  myTB,
  timeName = "time",
  time_0 = NA,
  time_t = NA,
  typeInd = "highBest"
)
}
\arguments{
\item{myTB}{the dataframe time by countries (complete and sorted by
increasing time).}

\item{timeName}{the name of the variable that contains time information.}

\item{time_0}{starting time to consider; if NA all times considered.}

\item{time_t}{last time to consider; if NA all times considered.}

\item{typeInd}{"highBest" is the default, "lowBest" is the alternative}
}
\value{
a list  with component res which contains ranking by each considered year
}
\description{
Countries are ranked for each time according to two types of indicators: higher is the best (highBest)
 or lower is the best (lowBest).
}
\examples{

# Example 1
# Sorted dataframe in the format years by countries:
require(tibble)
myTB  <- tibble::tribble(
~years, ~UK, ~DE, ~IT,
1988,   1201, 868, 578,
1989,   1150, 978, 682,
1990,   998,  1250, 332,
1991,  1600,  1350, 802
)

# Country ranking according to the indicator higher is the best:
res <- country_ranking(myTB,timeName="years")

# Country ranking according to the indicator lower is the best:
res1 <- country_ranking(myTB,timeName="years", typeInd="lowBest")

# Country ranking for some years only:
myres <- country_ranking(myTB,timeName="years", time_0=1989,time_t=1990,typeInd="lowBest" )

# Example 2
# Ranking of the Member States for the "emp_20_64_MS" dataset
data(emp_20_64_MS)
myCR<-country_ranking(emp_20_64_MS,timeName = "time", time_0 = 2007, time_t = 2010)

# Visualize the results for the first five countries:
myCR$res[1:6]


}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
