% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{parallel}
\alias{parallel}
\title{Parallel Connection of two systems}
\usage{
parallel(sys1, sys2, in1, in2, out1, out2)
}
\arguments{
\item{sys1}{LTI system object of tf, ss or zpk class}

\item{sys2}{LTI system object of tf, ss or zpk class}

\item{in1}{Numeric vector containing indexes to the inputs of sys1}

\item{in2}{Numeric vector containing indexes to the inputs of sys2}

\item{out1}{Numeric vector containing indexes to the outputs of sys1}

\item{out2}{Numeric vector containing indexes to the outputs of sys2}
}
\value{
The function returns a state-space model of the parallel-connected system with A, B, C, D matrices
}
\description{
\code{parallel} connects two systems in the parallel block form below

               |-->[System1]--|
           u-->+              0--->y
               |<--[System2]--|
}
\details{
\code{psys <-  parallel(sys1, sys2)} produces a state-
space system consisting of the parallel connection of sys1
and sys2 that connects all the inputs together and sums all the
outputs of the two systems.

 The parallel connection
is performed by appending the two systems, summing the specified
inputs and outputs, and removing the, now redundant, inputs and
outputs of system 2.

If sys1 and sys2 are transfer functions, then parallel(sys1, sys2) produces a parallel
connection of the two transfer function systems.

\code{parallel(sys1, sys2,IN1,IN2,OUT1,OUT2)}
connects the two systems in parallel by connecting the inputs
specified by IN1 and IN2 and by summing the outputs specified
by OUT1 and OUT2. The vector IN1 contains
indexes into the input vectors of sys1 while, IN2 contains indexes for sys2,
. Vectors OUT1 and OUT2 contain	indexes for the outputs of the sys1 and sys2 respectively.
}
\examples{
sys2 = ss(1,2,3,4)
sys3 = ss(6,7,8,9)
parallel(sys2, sys3)
parallel(tf(1, c(1,2,3)), ss(1,2,3,4))
parallel(tf(1, c(1,2,3)),tf(2, c(3,2,3)))
}
\seealso{
\code{\link{series}} \code{\link{feedback}} \code{\link{connect}}
}
