% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_cumulative_split.R
\name{cumulative_split_code}
\alias{cumulative_split_code}
\title{Use cumulative split coding}
\usage{
cumulative_split_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Contrast coding scheme that repeatedly dichotomizes the factor levels.
}
\details{
This scheme is similar to Helmert contrasts, but instead of comparing one
level to the accumulated mean of all previous levels, each comparison with
this scheme splits the levels into two groups: those below and including
the current level, and those above the current level. Conceptually this is
similar to continuation ratio logits used in ordinal models. For example,
with a four level factor with levels A, B, C, and D, the comparisons would
be:
\itemize{
\item A vs. BCD
\item AB vs. CD
\item ABC vs. D
}

In other words, each comparison splits the levels into two groups.
Each of these comparisons uses the cumulative mean of all the levels in
each group. The intercept is the grand mean.
}
\examples{


set.seed(111)
mydf <- data.frame(
  grp = rep(c("a", "b", "c", "d"), each = 400),
  val = c(
    rnorm(400, 2,   .05),
    rnorm(400, 4,   .05),
    rnorm(400, 12,  .05),
    rnorm(400, 20,  .05)
  )
) |>
  set_contrasts(grp ~ cumulative_split_code |
                      c("a-rest", "ab-rest", "abc-rest"))

# Coefficients: ~ 9.5, -10, -13, -14
lm(val ~ grp, data = mydf)

}
