% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rotate}
\alias{rotate}
\alias{ref_rotate}
\alias{rotate.Deque}
\alias{ref_rotate.Deque}
\title{Rotate Elements}
\usage{
rotate(x, n = 1L)

ref_rotate(x, n = 1L)

\method{rotate}{Deque}(x, n = 1L)

\method{ref_rotate}{Deque}(x, n = 1L)
}
\arguments{
\item{x}{any \code{R} object.}

\item{n}{\code{integer} number of steps to rotate}
}
\value{
For \code{Deque} returns the rotated \code{\link[=Deque]{Deque()}} object.
}
\description{
Rotate all elements \code{n} steps to the right. If n is
negative, rotate to the left.
}
\details{
While \code{rotate} uses copy semantics, \code{ref_rotate} works by reference,
that is, rotates in place on the original object.
}
\examples{
d = deque(1, 2, 3, 4)
rotate(d)
rotate(d, n = 2)
}
