% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops-arithmetic.R
\name{OpsArithmetic}
\alias{OpsArithmetic}
\alias{+.Container}
\alias{-.Container}
\alias{+.Deque}
\alias{-.Deque}
\alias{+.Dict}
\alias{-.Dict}
\alias{+.Set}
\alias{-.Set}
\title{Arithmetic Operators}
\usage{
\method{+}{Container}(x, y)

\method{-}{Container}(x, y)

\method{+}{Deque}(x, y)

\method{-}{Deque}(x, y)

\method{+}{Dict}(x, y)

\method{-}{Dict}(x, y)

\method{+}{Set}(x, y)

\method{-}{Set}(x, y)
}
\arguments{
\item{x, y}{Depending on the operator at least one must be of class
\code{\link[=Container]{Container()}} or the respective derived class and the other at least be
coercible to the respective class.}
}
\value{
For \code{Container}, \code{x + y} combines \code{x} and \code{y} into a new container
by appending \code{y} to \code{x}.

For Container, \code{x - y} element-wise discards all items of \code{y}
from \code{x}, given the element was contained in \code{x}. The result is always a
container.

For \verb{Deque,} \code{x + y} combines \code{x} and \code{y} into a new deque by
appending \code{y} to \code{x}.

For Deque, \code{x - y} element-wise removes all items of \code{y} from \code{x},
given the element was contained in \code{x}.

For  \code{Dict}, \code{x + y} combines \code{x} and \code{y} into a new dict by
updating \code{x} by \code{y} (see also \verb{[update()]}).

For \code{Dict}, \code{x - y} removes all keys from \code{x} that appear in \code{y}.

For \code{Set}, \code{x + y} performs the set union.

For \code{Set}, \code{x - y} performs the set difference.
}
\description{
Binary arithmetic operators for \code{\link[=Container]{Container()}} objects and
derived classes.
}
\examples{
c1 = container(1, 1:2)
c2 = container(2, 1:2)
c1 + c2     # same as c(c1, c2)
c2 + c1     # same as c(c2, c1)

c1 - c2
c2 - c1
c1 - c1
# Arithmetic
d1 = deque(1, 1:2)
d2 = deque(2, 1:2)
d1 + d2     # same as c(d1, d2)
d2 + d1     # same as c(d2, d1)

d1 - d2
d2 - d1
d1 - d1

# Arithmetic
d1 = dict(a = 1, b = list(1, 2))
d2 = dict(a = 2, b = list(1, 2))
d1 + d2      # same as update(d, d2)
d2 + d1      # same as update(d2, d)
try({
c(d1, d2)    # duplicated keys are not allowed for Dict
})
d1 - d2
d2 - d1
d1 - d1

# Arithmetic
s1 = setnew(1, 1:2)
s2 = setnew(2, 1:2)
s1 + s2     # same as s1 | s2 or c(c1, s2)
s2 + s1     # same

s1 - s2
s2 - s1

}
