% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thumbnail.R
\name{set_thumbnail}
\alias{set_thumbnail}
\title{Set content item thumbnail}
\usage{
set_thumbnail(content, path)
}
\arguments{
\item{content}{A content item.}

\item{path}{Either a path to a local file or a URL to an image available over
HTTP/HTTPS. If \code{path} is an HTTP or HTTPS URL, the image will first
be downloaded.}
}
\value{
The content item (invisibly).
}
\description{
Set the thumbnail for a content item.
}
\examples{
\dontrun{
client <- connect()
item <- content_item(client, "8f37d6e0-3395-4a2c-aa6a-d7f2fe1babd0")
set_thumbnail(item, "resources/image.png")
}

}
\seealso{
Other thumbnail functions: 
\code{\link{delete_thumbnail}()},
\code{\link{get_thumbnail}()},
\code{\link{has_thumbnail}()}

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_associations}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{lock_content}()},
\code{\link{permissions}},
\code{\link{search_content}()},
\code{\link{set_image_path}()},
\code{\link{set_integrations}()},
\code{\link{set_run_as}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
\concept{thumbnail functions}
