% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_conmet.R
\name{run_conmet}
\alias{run_conmet}
\title{Runs the Construct Measurement Evaluation Tool.}
\usage{
run_conmet()
}
\value{
Runs the 'ConMET' shiny application.
}
\description{
'ConMET' is an R-shiny application that facilitates performing and evaluating confirmatory factor analyses (CFAs) and is useful for running and reporting typical measurement models in applied psychology and management journals. 'ConMET' automatically creates, compares and summarizes CFA models. Most common fit indices (E.g., CFI and SRMR) are put in an overview table. 'ConMET' also allows to test for common method variance. The application is particularly useful for teaching and instruction of measurement issues in survey research.  \cr The application uses the \code{\link[lavaan]{cfa}} function from the 'lavaan' package (Rosseel, 2012) to run CFAs.
\cr \cr Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. \emph{Journal of Statistical Software, 48(2)}, 1-36. URL https://www.jstatsoft.org/v48/i02/.
}
\examples{
if(interactive()){
library(conmet)
run_conmet()
}
}
