ShowAllUtilities<-function(y,x,z)
{
	options(contrasts=c("contr.sum","contr.poly"))
	outdec<-options(OutDec="."); on.exit(options(outdec))
	options(OutDec=",")
	utls<-round(caUtilities(y,x,z),4)
	levnms<-c("intercept",as.matrix(z))
	lu<-cbind(levnms,utls)
	Utls<-as.data.frame(lu)
	print("Part worths (utilities) of levels (model parameters for whole sample):")
	print(Utls)
	uslall=round(caPartUtilities(y,x,z),3)
	print("Part worths (utilities) of all levels including intercept and reference levels a cross of respondents:")
	print(uslall)
	totalutils<-round(caTotalUtilities(y,x),3)
	print("Total utilities of profiles a cross of respondents:")
	print(totalutils)
	imp<-round(caImportance(y,x),2)
	print("Average importance of factors (attributes):")
	print(imp)	
	print(paste("Sum of average importance: ",sum(imp)),quote=FALSE)
}
