% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/house_vote.R
\name{cong_house_vote}
\alias{cong_house_vote}
\title{Request House Roll Call Vote Information}
\usage{
cong_house_vote(
  congress = NULL,
  session = NULL,
  number = NULL,
  item = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. Numeric.}

\item{session}{Session number (\code{1} or \code{2}). Numeric.}

\item{number}{Roll call vote number. Numeric.}

\item{item}{Information to request. Can be \code{'members'}.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is \code{TRUE}. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
A tibble or raw HTTP response if clean = FALSE.
}
\description{
Request House Roll Call Vote Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

cong_house_vote()

cong_house_vote(congress = 119, session = 1, number = 17)

cong_house_vote(congress = 119, session = 1, number = 17, item = 'members')
\dontshow{\}) # examplesIf}
}
