% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_intervals_norm}
\alias{plot_intervals_norm}
\title{Plot intervals as curved (normal distribution) areas}
\usage{
plot_intervals_norm(intervals, estimates = NULL, y_scale = 1,
  interval_value_labels = FALSE, estimate_value_labels = FALSE,
  interval_labels_offset = c(0, 0, 0.15, 0.15),
  estimate_labels_offset = c(0, 0.5 * y_scale), plot_estimate_marks = FALSE,
  estimate_mark_points = c(1.2 * graphics::strheight("M"), 0.05, -1.2 *
  graphics::strheight("M"), -0.05), ...)
}
\arguments{
\item{intervals}{The interval(s) to be plotted. Two column matrix.}

\item{estimates}{Estimates for each of the intervals (optional).}

\item{y_scale}{How tall the interval plots are to be drawn}

\item{interval_value_labels}{Logical value specifying whether interval value labels are to be added.}

\item{estimate_value_labels}{Logical value specifying whether estimate value labels are to be added.}

\item{interval_labels_offset}{Amount to offset interval labels by from the centre of the end
of the interval's plot. \code{c(x1, x2, y1, y2)}.}

\item{estimate_labels_offset}{Amount to offset estimate labels by. \code{c(x, y)}. Normally want the
estimate to be x-located at its value, but may want a y-offset to move it
above or below the plot shape that represents the interval.}

\item{plot_estimate_marks}{Whether to plot marks at the x location of the estimates.}

\item{estimate_mark_points}{y positions of the ends of the estimate marks as a numeric vector of length
4. Values are, in order: start (relative to centre), end (relative to box
top), start (relative to centre), end (relative to box bottom).}

\item{...}{Further parameters to be passed on.}
}
\description{
Plot intervals as curved (normal distribution) areas
}
