% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_proddiff.R
\name{get_proddiff}
\alias{get_proddiff}
\title{Looking Up Product Differentiation}
\source{
Data from Jon Haveman's International Trade Data page <http://www.macalester.edu/research/economics/PAGE/HAVEMAN/Trade.Resources/TradeData.html#Rauch>.
}
\usage{
get_proddiff(sourcevar, origin, setting = "CON", prop = "")
}
\arguments{
\item{sourcevar}{An input character vector of industry/product codes.}

\item{origin}{A string setting the input coding scheme. Supports the following classifications: "HS0" (1988/92), "HS1" (1996), "HS2" (2002), "HS3" (2007), "HS4" (2012), "HS5" (2017), "HS" (combined), "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006), "NAICS" (combined).}

\item{setting}{Choose "CON" (conservative, default) or "LIB" (liberal) classification.}

\item{prop}{Can be set to "n", "r", or "w", in which case the function will return, respectively, the proportion of type "n", "r", or "w" in the resulting vector of Rauch indices. If prop is not set to any of these, then the function returns, for each input code, a dataframe that summarizes all the frequencies and proportions of type "w", "r", and "n".}
}
\value{
Concords each element of the input vector to 4-digit SITC2 codes, then uses the corresponding codes as input to extract Rauch product differentiation indices.
}
\description{
Returns Rauch's classification of product differentiation. Rauch classifies 4-digit SITC2 codes according to three possible types: differentiated products ("n"), reference priced ("r"), and homogeneous goods traded on an organized exchange ("w").
}
\note{
Always include leading zeros in codes (e.g. use HS code 010110 instead of 10110)---results may be buggy otherwise.
}
\examples{
# SITC2 input
get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC2", setting = "CON", prop = "")

get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC2", setting = "CON", prop = "r")

get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC2", setting = "CON", prop = "w")

get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC2", setting = "CON", prop = "n")

get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC2", setting = "LIB", prop = "")

# SITC3 input
get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC3", setting = "CON", prop = "")

# SITC4 input
get_proddiff(sourcevar = c("22240", "04110"), origin = "SITC4", setting = "CON", prop = "")

# HS input
get_proddiff(sourcevar = c("1206", "1001", "8546"), origin = "HS", setting = "CON", prop = "")

# NAICS input
get_proddiff(sourcevar = c("111120", "326199"), origin = "NAICS", setting = "CON", prop = "")
}
\references{
Rauch, James E. 1999. "Networks Versus Markets in International Trade," Journal of International Economics 48(1): 7--35.
}
