% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_desc.R
\name{get_desc}
\alias{get_desc}
\title{Looking Up Product Description}
\source{
Data consolidated from
\itemize{
  \item The U.S. Census Bureau <https://www.census.gov/>
  \item The U.S. Bureau of Labor Statistics <https://www.bls.gov/>
  \item UN Comtrade <https://comtrade.un.org/>
  \item UN Trade Statistics <https://unstats.un.org/unsd/trade/default.asp>
}
}
\usage{
get_desc(sourcevar, origin)
}
\arguments{
\item{sourcevar}{A character vector of input codes.}

\item{origin}{A string indicating one of the following industry/product classifications: "HS0" (1988/92), "HS1" (1996), "HS2" (2002), "HS3" (2007), "HS4" (2012), "HS5" (2017), "HS" (combined), "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006), "NAICS2002", "NAICS2007", "NAICS2012", "NAICS2017", "ISIC2" (1968), "ISIC3" (1989), "ISIC4" (2008), "BEC".}
}
\value{
A character vector giving the title/description of each element of the input codes.
}
\description{
Returns the description of product codes.
}
\note{
Always include leading zeroes in codes (e.g. use HS code 010110 instead of 10110)---results may be buggy otherwise.
}
\examples{
# HS
get_desc(sourcevar = c("120600", "854690"), origin = "HS")

# Returns NA when no concordances exist and gives warning message
get_desc(sourcevar = c("120600", "120601", "854690"), origin = "HS")

# HS0
get_desc(sourcevar = c("120600", "854690"), origin = "HS0")

# HS1
get_desc(sourcevar = c("120600", "854690"), origin = "HS1")

# HS2
get_desc(sourcevar = c("120600", "854690"), origin = "HS2")

# HS3
get_desc(sourcevar = c("120600", "854690"), origin = "HS3")

# HS4
get_desc(sourcevar = c("120600", "854690"), origin = "HS4")

# HS5
get_desc(sourcevar = c("120600", "854690"), origin = "HS5")

# NAICS 2002
get_desc(sourcevar = c("111120", "326199"), origin = "NAICS2002")

# NAICS 2007
get_desc(sourcevar = c("111120", "326199"), origin = "NAICS2007")

# NAICS 2012
get_desc(sourcevar = c("111120", "326199"), origin = "NAICS2012")

# NAICS 2017
get_desc(sourcevar = c("111120", "326199"), origin = "NAICS2017")

# ISIC2
get_desc(sourcevar = c("3114", "3831"), origin = "ISIC2")

# ISIC3
get_desc(sourcevar = c("1512", "3110"), origin = "ISIC3")

# ISIC4
get_desc(sourcevar = c("1512", "3110"), origin = "ISIC4")

# SITC1
get_desc(sourcevar = c("4216", "7232"), origin = "SITC1")

# SITC2
get_desc(sourcevar = c("4236", "7732"), origin = "SITC2")

# SITC3
get_desc(sourcevar = c("4221", "7732"), origin = "SITC3")

# SITC4
get_desc(sourcevar = c("4221", "7732"), origin = "SITC4")

# BEC
get_desc(sourcevar = c("001", "111"), origin = "BEC")
}
