% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concord_sitc_naics.R
\name{concord_sitc_naics}
\alias{concord_sitc_naics}
\title{Converting SITC and NAICS Codes}
\source{
SITC-NAICS concordances are mapped through HS (combined):
\itemize{
  \item SITC-HS concordance tables are from the World Integrated Trade Solution (WITS), World Bank <https://wits.worldbank.org/product_concordance.html> and United Nations Trade Statistics <https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp>.
  \item HS-NAICS concordance tables are from Pierce and Schott (2009, 2018) <https://faculty.som.yale.edu/peterschott/international-trade-data/>.
}
}
\usage{
concord_sitc_naics(sourcevar, origin, destination, dest.digit = 4, all = FALSE)
}
\arguments{
\item{sourcevar}{An input character vector of SITC or NAICS codes. The function accepts 1 to 5-digit codes for SITC and 2, 4, 6-digit codes for NAICS.}

\item{origin}{A string setting the input industry classification: "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006), "NAICS" (combined).}

\item{destination}{A string setting the output industry classification: "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006), "NAICS" (combined).}

\item{dest.digit}{An integer indicating the preferred number of digits for output codes. Allows 1 to 5-digit codes for SITC and 2, 4, 6-digit codes for NAICS. The default is 4 digits.}

\item{all}{Either TRUE or FALSE. If TRUE, the function will return (1) all matched outputs for each input, and (2) the share of occurrences for each matched output among all matched outputs. Users can use the shares as weights for more precise concordances. If FALSE, the function will only return the matched output with the largest share of occurrences (the mode match). If the mode consists of multiple matches, the function will return the first matched output.}
}
\value{
The matched output(s) for each element of the input vector. Either a list object when all = TRUE or a character vector when all = FALSE.
}
\description{
Concords Standard International Trade Classification classification codes (SITC Revision 1, 2, 3, 4) to and from North American Industry Classification System codes (NAICS combined).
}
\note{
Always include leading zeros in codes (e.g. use SITC code 01211 instead of 1211)---results may be buggy otherwise.
}
\examples{
## SITC4 to NAICS
# one input: one-to-one match
concord_sitc_naics(sourcevar = "22240",
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = FALSE)
concord_sitc_naics(sourcevar = "22240",
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = TRUE)

# two inputs: multiple-to-one match
concord_sitc_naics(sourcevar = c("22240", "04110"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = FALSE)
concord_sitc_naics(sourcevar = c("22240", "04110"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = TRUE)

# two inputs: repeated
concord_sitc_naics(sourcevar = c("22240", "22240"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = FALSE)

# one to multiple matches
concord_sitc_naics(sourcevar = c("22240", "00190"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = TRUE)

# if no match, will return NA and give warning message
concord_sitc_naics(sourcevar = c("22240", "00160"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = FALSE)

# 4-digit inputs
concord_sitc_naics(sourcevar = c("2224", "0019"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = TRUE)

# 4-digit outputs
concord_sitc_naics(sourcevar = c("22240", "00190"),
                   origin = "SITC4", destination = "NAICS",
                   dest.digit = 6, all = TRUE)

## NAICS to SITC4
concord_sitc_naics(sourcevar = c("111120", "326199"),
                   origin = "NAICS", destination = "SITC4",
                   dest.digit = 4, all = TRUE)
}
