% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colley.R
\name{colley}
\alias{colley}
\alias{rate_colley}
\alias{rank_colley}
\title{Colley method}
\usage{
rate_colley(cr_data)

rank_colley(cr_data, keep_rating = FALSE, ties = c("average", "first",
  "last", "random", "max", "min"), round_digits = 7)
}
\arguments{
\item{cr_data}{Competition results in format ready for
\link[comperes:as_longcr]{as_longcr()}.}

\item{keep_rating}{Whether to keep rating column in ranking output.}

\item{ties}{Value for \code{ties} in \code{\link[=round_rank]{round_rank()}}.}

\item{round_digits}{Value for \code{round_digits} in \code{\link[=round_rank]{round_rank()}}.}
}
\value{
\code{rate_colley()} returns a \link[tibble:tibble]{tibble} with columns
\code{player} (player identifier) and \code{rating_colley} (Colley
\link[=rating-ranking]{rating}). The mean rating should be 0.5. \strong{Bigger value
indicates better player performance}.

\code{rank_colley()} returns a \code{tibble} with columns \code{player}, \code{rating_colley} (if
\code{keep_rating = TRUE}) and \code{ranking_colley} (Colley \link[=rating-ranking]{ranking}
computed with \code{\link[=round_rank]{round_rank()}}).
}
\description{
Functions to compute \link[=rating-ranking]{rating} and \link[=rating-ranking]{ranking}
using Colley method.
}
\details{
This rating method was initially designed for games between two
players. There will be an error if in \code{cr_data} there is a game not between
two players. Convert input competition results manually or with
\link[comperes:to_pairgames]{to_pairgames()} from \code{comperes} package.

It is assumed that score is numeric and higher values are better for the
player.

Computation is done based only on the games between players of interest (see
Players). \strong{Note} that it isn't necessary for all players of interest to be
present in \code{cr_data} but it might be a good idea in order to obtain plausible
outcome rating.

The outline of the Colley method is as follows:
\enumerate{
\item Compute Colley matrix: diagonal elements are equal to number of games
played by certain player \emph{plus 2}, off-diagonal are equal to minus number of
common games played. This matrix will be the matrix of system of linear
equations (SLE).
\item Compute right-hand side of SLE as 1 + 0.5*("number of player's wins" -
"number of player's losses").
\item Solve the SLE. The solution is the Colley rating.
}
}
\section{Players}{


\code{comperank} offers a possibility to handle certain set of players. It is done
by having \code{player} column (in \link[comperes:as_longcr]{longcr} format) as factor
with levels specifying all players of interest. In case of factor the result
is returned only for players from its levels. Otherwise - for all present
players.
}

\examples{
rate_colley(ncaa2005)

rank_colley(ncaa2005)

rank_colley(ncaa2005, keep_rating = TRUE)

}
\references{
Wesley N. Colley (2002) \emph{Colley’s Bias Free College Football
Ranking Method: The Colley Matrix Explained}. Available online at
\url{http://www.colleyrankings.com}
}
