% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assocplot.R
\name{assocplot}
\alias{assocplot}
\title{Multiple PGS Associations Plot}
\usage{
assocplot(score_table = NULL, axis = "vertical", pval = FALSE)
}
\arguments{
\item{score_table}{a dataframe with association results with at least the
following columns:
\itemize{
\item PGS: the name of the PGS
\item Phenotype: the name of Phenotype
\item Phenotype_type: either \code{'Continuous'}, \code{'Ordered Categorical'}, \code{'Categorical'} or \code{'Cases/Controls'}
\item Effect: if Phenotype_type is Continuous, it represents the Beta coefficient of linear regression, OR of logistic regression otherwise
\item lower_CI: lower confidence interval of the related Effect (Beta or OR)
\item upper_CI: upper confidence interval of the related Effect (Beta or OR)
\item P_value: associated P-value
}}

\item{axis}{a character, \code{'horizontal'} or \code{"vertical"} (the default) specifying the rotation
of the plot}

\item{pval}{a  parameter specifying information on how to display P-value
\itemize{
\item if pval is FALSE, P-value does not appear on the plot
\item if pval is TRUE, P-value always appears next to the signal
\item if pval is a number, P-value will appear if the P-value is inferior to
this given number.
}}
}
\value{
return either:
\itemize{
\item a ggplot object representing the association results.
\item a list of two ggplot objects, accessible by $continuous_phenotype and
$discrete_phenotype, if there are both Continuous Phenotypes and Discrete
Phenotypes (i.e. "Categorical" or "Cases/Controls")
}
}
\description{
\code{assocplot()} takes a data frame of associations. Returns plot of the associations
from \code{assoc()} (ggplot2 object or list of ggplot object)
}
