% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-methods.R
\name{get_columns}
\alias{get_columns}
\title{Get a project's columns}
\usage{
get_columns(
  project_id = NULL,
  project_name = NULL,
  workspace_name = NULL,
  api_key = NULL,
  archived = FALSE
)
}
\arguments{
\item{project_id}{Project ID.}

\item{project_name}{Project name (can also be specified using the \code{COMET_PROJECT_NAME}
parameter as an environment variable or in a comet config file).}

\item{workspace_name}{Workspace name (can also be specified using the \code{COMET_WORKSPACE}
parameter as an environment variable or in a comet config file).}

\item{api_key}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}

\item{archived}{If \code{TRUE}, retrieve archived experiments. Otherwise, retrieve
active experiments.}
}
\description{
Either \code{project_id} should be provided, or both \code{project_name} and \code{workspace_name}
should be provided. If \code{project_id} is provided, then \code{project_name} and \code{workspace_name}
are ignored.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables defined
get_columns()
}

}
