% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathfinder.r
\name{pathfinder.conceptmaps}
\alias{pathfinder.conceptmaps}
\title{Creating a Pathfinder network from a conceptmaps object}
\usage{
\method{pathfinder}{conceptmaps}(data, q = 2, r = 1, threshold = 0,
  directed = F, prune.edges = F, return.cm = F, filename = "", ...)
}
\arguments{
\item{data}{A conceptmaps object.}

\item{q}{The parameter q used in the Pathfinder algorithm. The resulting graph will be q-triangular.}

\item{r}{The parameter r used in the Pathfinder algorithm for the r-metric.}

\item{threshold}{A numeric value used for pruning the graph before the Pathfinder algorithm. The pruning works in conjunction with
the value of \code{prune.edges}.}

\item{directed}{if TRUE, the direction of the edges will be kept and the resulting Pathfinder network will be directed as well.}

\item{prune.edges}{If TRUE, each entry of the weight matrix that is lower than \code{threshold} will be set to 0 and columns
with a resulting sum of 0 are removed. If FALSE, only columns of the weight matrix with a sum of less than \code{threshold} 
will be removed.}

\item{return.cm}{If TRUE, a conceptmap object will be returned. Otherwise, an igrpah object will be returned.}

\item{filename}{Optional. If specified, the resulting Pathfinder network will be stored in TGF format in the given file.}

\item{...}{-}
}
\value{
Depending on \code{return.cm} either an igraph object or a conceptmap object that represents the Pathfinder network.
If an igraph object is returned, the graph will be weighted.
}
\description{
\code{pathfinder} creates the Pathfinder network from a given set of conceptmaps. The conecpts of each concept map are
unified, then the concept maps are transformed into a weight matrix and \code{\link{pathfinder.matrix}} is called on the data.
}
\examples{
#Create concept maps from three random graphs
require("igraph")
g1 = set.vertex.attribute(erdos.renyi.game(5, 0.7, type="gnp"), "name", value=1:5)
g2 = set.vertex.attribute(erdos.renyi.game(5, 0.7, type="gnp"), "name", value=1:5)
g3 = set.vertex.attribute(erdos.renyi.game(5, 0.7, type="gnp"), "name", value=1:5)

#Create conceptmaps object from three conceptmap objects
simple_cms = conceptmaps(list(conceptmap(g1), conceptmap(g2), conceptmap(g3)))

#Create Pathfinder network from data and return a conceptmap object
cm = pathfinder(simple_cms, q=1, return.cm=TRUE)
}
