% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif.R
\name{vif}
\alias{vif}
\title{Compute variance inflation factors from a correlation matrix}
\usage{
vif(m = NULL, quiet = FALSE, ...)
}
\arguments{
\item{m}{(required, matrix) Correlation matrix generated via \code{stats::cor()} or \code{\link[=cor_matrix]{cor_matrix()}}. Must have named dimensions. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
named numeric vector
}
\description{
Computes the Variance Inflation Factors from a correlation matrix in two steps:
\itemize{
\item Applies \code{base::solve()} to transform the correlation matrix into a precision matrix, which is the inverse of the covariance matrix between all variables in \code{predictors}.
\item Applies \code{base::diag()} to extract the diagonal of the precision matrix, which contains the variance of the regression of each predictor against all other predictors, also known as Variance Inflation Factor
}
}
\section{Variance Inflation Factors}{


VIF for predictor \eqn{a} is computed as \eqn{1/(1-R^2)}, where \eqn{R^2} is
the multiple R-squared from regressing \eqn{a} on the other predictors.
Recommended maximums commonly used are 2.5, 5, and 10.
}

\examples{
data(vi_smol, vi_predictors_numeric)

m <- cor_matrix(
  df = vi_smol,
  predictors = vi_predictors_numeric[1:5]
)

vif(m)
}
\references{
\itemize{
\item David A. Belsley, D.A., Kuh, E., Welsch, R.E. (1980). Regression Diagnostics: Identifying Influential Data and Sources of Collinearity. John Wiley & Sons. DOI: 10.1002/0471725153.
}
}
\seealso{
Other multicollinearity_assessment: 
\code{\link{collinear_stats}()},
\code{\link{cor_clusters}()},
\code{\link{cor_cramer}()},
\code{\link{cor_df}()},
\code{\link{cor_matrix}()},
\code{\link{cor_stats}()},
\code{\link{vif_df}()},
\code{\link{vif_stats}()}
}
\concept{multicollinearity_assessment}
