% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportNparLD}
\alias{reportNparLD}
\title{Report the model produced by nparLD. The model provided must be the model generated by the command 'nparLD' \code{\link[nparLD]{nparLD}} (see \url{https://CRAN.R-project.org/package=nparLD}).}
\usage{
reportNparLD(model, dv = "Testdependentvariable", write_to_clipboard = FALSE)
}
\arguments{
\item{model}{the model}

\item{dv}{the dependent variable}

\item{write_to_clipboard}{whether to write to the clipboard}
}
\value{
A message describing the statistical results.
}
\description{
#' Only significant main and interaction effects are reported.
P-values are rounded for the third digit and relative treatment effects (RTE) are included when available.
Attention: the independent variables of the formula and the term specifying the participant must be factors (i.e., use as.factor()).
}
\details{
#' To easily copy and paste the results to your manuscript, the following commands must be defined in Latex:
\code{\\newcommand{\\F}{\\textit{F=}}}
\code{\\newcommand{\\p}{\\textit{p=}}}
\code{\\newcommand{\\pminor}{\\textit{p$<$}}}
}
\examples{
\donttest{
if (requireNamespace("nparLD", quietly = TRUE)) {
  # Small toy data set for nparLD
  set.seed(123)
  example_data <- data.frame(
    Subject = factor(rep(1:10, each = 3)),
    Time    = factor(rep(c("T1", "T2", "T3"), times = 10)),
    TLX1    = stats::rnorm(30, mean = 50, sd = 10)
  )

  # Fit nparLD model
  model <- nparLD::nparLD(
    TLX1 ~ Time,
    data        = example_data,
    subject     = "Subject",
    description = FALSE
  )

  # Report the nparLD result
  reportNparLD(model, dv = "TLX1")
  }
}
}
