% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{step_s}
\alias{step_s}
\alias{as.data.frame.survfit}
\alias{as.data.frame.summary.survfit}
\alias{predict_coxph_tt}
\alias{predict_coxph_tv}
\alias{plot_coxph_functional}
\title{Utilities}
\usage{
step_s(
  data,
  x,
  y,
  ymin,
  ymax,
  group,
  add_origin = TRUE,
  x_origin = 0,
  y_origin = 1
)

\method{as.data.frame}{survfit}(x, row.names, optional, type = c("expanded", "plain"), ...)

\method{as.data.frame}{summary.survfit}(x, row.names, optional, type = c("expanded", "plain"), ...)

predict_coxph_tt(object, times, type = "lp", se.fit = FALSE, x = 1, ...)

predict_coxph_tv(object, data, id)

plot_coxph_functional(
  formula,
  data,
  x = NULL,
  pch = 19,
  ylab = "Martingale residual for null model",
  smoother = c("loess", "lm"),
  smoother.formula = resi ~ xi,
  smoother.args = list(),
  points.args = list(),
  ...
)
}
\arguments{
\item{data}{a dataset for evaluation of the coxph model}

\item{x}{a numeric vector for the smoother (defaults to the 401 values between the range)}

\item{y}{name of the y-variable (required)}

\item{ymin}{name of the ymin variable (optional)}

\item{ymax}{name of the ymax variable (optional)}

\item{group}{name of a grouping variable (optional)}

\item{add_origin}{logical for whether to add an origin to the start of each group}

\item{x_origin}{double for the value of x at the origin}

\item{y_origin}{double for the value of y, ymin and ymax at the origin}

\item{row.names}{not used (in generic signature)}

\item{optional}{not used (in generic signature)}

\item{type}{a character for the type of prediction (currently only
the linear predictor for the tt argument)}

\item{...}{other arguments to pass to the plot function}

\item{object}{a coxph object}

\item{times}{a numeric vector of times to evaluate the linear
predictor}

\item{se.fit}{a logical for whether to return the standard errors}

\item{id}{a character for the subject id}

\item{formula}{a formula with a Surv on the lhs and a single variable on the rhs}

\item{pch}{an integer for the pch argument in the plot for the residuals}

\item{ylab}{a character for the ylab argument in the plot}

\item{smoother}{a character for the name of the smoother}

\item{smoother.formula}{a formula for the smoother in terms of resi and xi}

\item{smoother.args}{a list of arguments to pass to the smoother function}

\item{points.args}{a list of arguments to pass to the points function}
}
\value{
expanded data-frame with the same names

a vector of fitted values (when se.fit=FALSE) or a data-frame
with fitted and se.fit columns (when se.fit=TRUE)

an update of data with survival probabilities

invisible plot return
}
\description{
Given a data-frame with an "s" step function, expand the data-frame
to include the steps.

Given a survfit object, return a data-frame

Given a summary.survfit object, return a data-frame

Calculates lp=tt(x). Typically, the tt function should
include an intercept term (see the examples below). Note that
spline terms assume that the x argument is multiplicative;
moreover, the additional arguments are not passed. For other
types of tt terms, the x is passed directly to the tt function
together with other arguments.
}
\examples{
  step_s(data.frame(g=c(1,1), a=1:2, b=4:5), a, b)
  step_s(data.frame(g=c(2,2), a=3:4, b=6:7), a, b)
  step_s(data.frame(g=c(1,1,2,2), a=1:4, b=4:7), a, b, group=g)
  library(survival)
  library(tinyplot)
  sfit1 = survfit(Surv(time,status)~rx, data=survival::colon,
                  subset=etype==1)
  with(as.data.frame(sfit1),
       tinyplot::plt(surv~time|strata,ymin=lower,ymax=upper,type="ribbon"))
  library(survival)
  library(tinyplot)
  sfit1 = survfit(Surv(time,status)~rx, data=survival::colon,
                  subset=etype==1)
  with(as.data.frame(sfit1, type="expanded"),
       tinyplot::plt(surv~time|strata,ymin=lower,ymax=upper,type="ribbon"))
 library(splines)
 library(tinyplot)
 fit1 = coxph(Surv(time,status)~tt(treat),data=breast_rfs,
              tt=function(x,t,...) x*cbind(1,t))
 fit2 = coxph(Surv(time,status)~tt(treat),data=breast_rfs,
              tt=function(x,t,...) x*ns(t,df=4,intercept=TRUE))
 times = seq(0,2500,len=301L)
 df1 = transform(predict_coxph_tt(fit1,times,se.fit=TRUE),
                 lower=exp(fitted-1.96*se.fit),
                 upper=exp(fitted+1.96*se.fit),
                 fitted=exp(fitted),
                 model="linear",times=times)
 df2 = transform(predict_coxph_tt(fit2,times,se.fit=TRUE),
                 lower=exp(fitted-1.96*se.fit),
                 upper=exp(fitted+1.96*se.fit),
                 fitted=exp(fitted),
                 model="ns",times=times)
 with(rbind(df1,df2),
      plt(fitted ~ times | model, ymin=lower, ymax=upper, type="ribbon",
          xlab="Time since diagnosis (days)",
          ylab="Hazard ratio comparing treated with untreated"))
 with(subset(breast_rfs,status==1), rug(time))
library(survival)
liver = transform(collett::liverbase, lbr=NULL)
liver = tmerge(liver, liver, id=patient, status=event(time,status))
liver = tmerge(liver,
               rbind(with(collett::liverbase, data.frame(patient,tstart=0,lbr)),
                     with(collett::lbrdata0, data.frame(patient,tstart=time,lbr))),
           id=patient, lbr = tdc(tstart,lbr))
fit3 = coxph(Surv(tstart,tstop,status)~lbr+treat,liver)
predict_coxph_tv(fit3,data=subset(liver,patient \%in\% c(1,7)),
                 id="patient")
library(survival)
par(mfrow=c(2,2))
plot_coxph_functional(Surv(time,status)~hb, data=collett::myeloma,
                      xlab="Value of Hb")
plot_coxph_functional(Surv(time,status)~bun, data=collett::myeloma,
                      xlab="Value of Bun")
plot_coxph_functional(Surv(time,status)~log(bun), data=collett::myeloma,
                      xlab="Value of log Bun")
}
