% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.r
\name{has}
\alias{has}
\alias{has_results}
\alias{has_errors}
\alias{has_warnings}
\alias{has_messages}
\alias{has_output}
\title{Determine which elements contain a type of side effect.}
\usage{
has_results(x)

has_errors(x)

has_warnings(x)

has_messages(x)

has_output(x)
}
\arguments{
\item{x}{A \code{safely_mapped} or \code{quietly_mapped} list to tally.}
}
\value{
A logical vector, of the same length as \code{x}, which is \code{TRUE} for
elements that contain a type of side effect and \code{FALSE} otherwise.
}
\description{
Returns a logical vector indicating which elements contain a type of side
effect. If you have a large data frame or list, you can use this to isolate
the element that contain warnings, for example, or messages.s
}
\details{
The \verb{has_*()} functions power the `tally_*()`` functions and, in turn,
the \code{\link[=summary]{summary()}} method.
}
\examples{

library(tibble)
library(dplyr)
library(tidyr)
library(collateral)

list("a", 10, 100) \%>\% map_safely(log) \%>\% has_errors()
list(5, -12, 103) \%>\% map_quietly(log) \%>\% has_warnings()

# if you're working with list-columns, the tally functions are useful
# in conjunction with dplyr::summarise()
mtcars \%>\%
  rownames_to_column(var = "car") \%>\%
  as_tibble() \%>\%
  select(car, cyl, disp, wt) \%>\%
  # spike some rows in cyl == 4 to make them fail
  mutate(wt = dplyr::case_when(
    wt < 2 ~ -wt,
    TRUE ~ wt)) \%>\%
  # nest and do some operations quietly()
  nest(data = -cyl) \%>\%
  mutate(qlog = map_quietly(data, ~ log(.$wt))) \%>\%
  filter(has_warnings(qlog))

}
