% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog_contour.r
\name{cog_contour}
\alias{cog_contour}
\title{Compute Contour-Based Center of Gravity (COG)}
\usage{
cog_contour(img, origin = c("bottomleft", "topleft"))
}
\arguments{
\item{img}{An image input. Supported inputs are:
\itemize{
\item A file path to an image file (e.g., PNG, JPEG, TIFF, BMP).
\item A \code{cimg} object from the \pkg{imager} package (if \pkg{imager} is installed).
\item A numeric matrix \code{[h, w]} (grayscale) or numeric array \code{[h, w, ch]} (color).
}
The image should be binary in the sense that background pixels take the value 1 (pure white),
and all other pixels are treated as stroke (foreground) pixels.}

\item{origin}{A character string indicating the location of the image origin.
Use \code{"bottomleft"} (default) if the y-axis increases upward (Cartesian),
or \code{"topleft"} if the y-axis increases downward (as in image arrays).}
}
\value{
A list containing:
\describe{
\item{\code{statistics}}{A data frame with the following components:
\itemize{
\item \code{center_x}, \code{center_y}: The (x, y) coordinates of the COG in pixel coordinates of the input image.
\item \code{center_x_trim}, \code{center_y_trim}: The COG coordinates relative to the trimmed glyph region, excluding image margins.
\item \code{center_x_std}, \code{center_y_std}: The standardized COG coordinates ranging from 0 to 1, based on the trimmed region's width and height.
\item \code{margin_left}, \code{margin_right}, \code{margin_top}, \code{margin_bottom}: Margins between the glyph and the image boundary.
\item \code{width_original}, \code{height_original}: Dimensions of the original image.
\item \code{width_trim}, \code{height_trim}: Width and height of the trimmed glyph region, excluding margins.
\item \code{area}: The number of pixels inside the convex hull (i.e., the total mass used to compute the COG).
}
}
\item{\code{points}}{A data frame of (x, y) coordinates representing the contour points of the convex polygon.}
}
}
\description{
Computes the center of gravity (COG) of a character-like binary image using its outer contour.
}
\details{
In the contour-based method, the center of gravity (COG) is defined as the geometrical centroid
of the convex hull (the smallest convex polygon) that encloses the stroke region of the character.
The convex hull is estimated by tracing the outer contour of the glyph and computing the minimal convex polygon
that wraps all stroke pixels, i.e., the foreground pixels whose intensity values are not equal to 1 (pure white).
The centroid is then calculated as the arithmetic mean of the (x, y) coordinates
of all pixels located within the interior of the convex polygon.

Mathematically, the contour-based center of gravity \eqn{(G_x, G_y)} is defined as the weighted mean of pixel coordinates
within the polygon region, where each pixel contributes a value of 1 (unit mass) and background pixels are excluded.
Specifically, let \eqn{p(x, y)} be an indicator function such that \eqn{p(x, y) = 1} if the pixel \eqn{(x, y)} lies
inside the convex polygon and \eqn{p(x, y) = 0} otherwise. Then the horizontal and vertical components
of the COG are computed as:

\deqn{
G_x = (\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y) \cdot x) / (\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y))
}
\deqn{
G_y = (\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y) \cdot y) / (\sum_{x=1}^{w} \sum_{y=1}^{h} p(x, y))
}

where \eqn{w} and \eqn{h} denote the width and height of the image, respectively.

This method was originally proposed by Kotani and colleagues (2004, 2011) and has been used
in character analysis and font design to reflect the perceived shape of glyphs more robustly
than simple stroke averaging.
}
\examples{
data(img_A) # load example image from the package
result <- cog_contour(img_A, origin = "bottomleft")

result$statistics # summary data frame
result$points # contour polygon vertices (x, y, angle)
result$origin # image origin specification

}
\references{
Kotani, A. (2011). Contour-based evaluation method of center of gravity on characters and its application to font development. \emph{Memoirs of Shonan Institute of Technology}, \strong{45}(1), 23–33. \url{https://shonan-it.repo.nii.ac.jp/?action=repository_view_main_item_detail&item_id=368}

Kotani, A., Asai, Y., Nakamura, Y., Otuka, M., Mituyama, Y., & Onoye, T. (2004). Contour-based evaluation method of center of gravity on “LCFONT.” \emph{IPSJ SIG Technical Report}, \strong{115}, 63–70. \url{https://ipsj.ixsq.nii.ac.jp/records/36793}
}
