% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input_args.R
\name{check_input_args}
\alias{check_input_args}
\title{Sanity checks for arguments passed to predict_delta_comps()}
\usage{
check_input_args(dataf, y, comps, covars, deltas)
}
\arguments{
\item{dataf}{A \code{data.frame} containing data}

\item{y}{Name (as string/character vector of length 1) of outcome variable in \code{dataf}}

\item{comps}{Character vector of names of compositions in \code{dataf}. See details for more information.}

\item{covars}{Character vector of covariates names  (non-comp variables) in \code{dataf} or NULL for none (default).}

\item{deltas}{A vector of time-component changes (as proportions of compositions , i.e., values between -1 and 1). Optional.}
}
\description{
Sanity checks for arguments passed to predict_delta_comps()
}
\details{
Throws errors for any problematic input. Returns \code{TRUE} invisibly if no issues found.
}
