% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmps.R
\name{get_CMPS}
\alias{get_CMPS}
\title{Compute the CMPS score}
\usage{
get_CMPS(input_ccp, Tx = 25)
}
\arguments{
\item{input_ccp}{a list of positions for (consistent) correlation peaks}

\item{Tx}{integer, the tolerance zone is \verb{+/- Tx}}
}
\value{
a list of six components:
\itemize{
\item \code{CMPS_score}: computed CMPS score
\item \code{nseg}: the number of basis segments
\item \code{congruent_pos}: the congruent position that results in the CMPS score
\item \code{congruent_seg}: a boolean vector of the congruent matching profile segments
\item \code{congruent_seg_idx}: the index of the congruent matching profile segments
\item \code{pos_df}: a dataframe that includes all positions and their corresponding CMPS score
}
}
\description{
Compute the CMPS score from a list of positions of (consistent) correlation peaks.
}
\examples{
data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
land1_2 <- bullets$sigs[bullets$bulletland == "1-2"][[1]]
x <- land2_3$sig
y <- land1_2$sig
segments <- get_segs(x, len = 50)
nseg <- length(segments$segs)
seg_scale_max <- 3
npeaks_set <- c(5,3,1)
outlength <- c(50, 100, 200)

ccp_list <- lapply(1:nseg, function(nseg) {
 ccr_list <- lapply(1:seg_scale_max, function(seg_scale) {
   get_ccr_peaks(y, segments, seg_outlength = outlength[seg_scale], 
   nseg = nseg, npeaks = npeaks_set[seg_scale])
 })

 get_ccp(ccr_list, Tx = 25)
})
cmps <- get_CMPS(ccp_list, Tx = 25)
}
