% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{make_Dummy}
\alias{make_Dummy}
\title{Create Dummy Variables}
\usage{
make_Dummy(Data = dat, features = c("sex", "cause_burn"), reff = "first")
}
\arguments{
\item{Data}{A data frame containing the data.}

\item{features}{A character vector of feature names for which dummy variables are to be created.}

\item{reff}{A character string indicating the reference level. It can be either "first" or "last".}
}
\value{
A list containing two elements:
\item{New_Data}{A data frame with the original data and the newly created dummy variables.}
\item{Original_Data}{The original data frame.}
}
\description{
This function creates dummy variables for specified features in a dataset.
}
\examples{
dat <- data.frame(sex = c('M', 'F', 'M'), cause_burn = c('A', 'B', 'A'))
result <- make_Dummy(Data = dat, features = c('sex', 'cause_burn'), reff = "first")
print(result$New_Data)
}
