% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{plot_cmgnd}
\alias{plot_cmgnd}
\title{Plot Marginal and Mixture Component Densities of the CMGND Model}
\usage{
plot_cmgnd(x, parameters, model = "")
}
\arguments{
\item{x}{A numeric vector representing the observed data points.}

\item{parameters}{A matrix or data.frame containing the parameters of the CMGND model.}

\item{model}{A character indicating the model type name. Default value model="".
Alternatively, this can be an object returned from the `cmgnd()` function, representing an estimated CMGND model.}
}
\value{
A plot illustrating the marginal density along with the densities of the individual mixture components for the given data `x`.
}
\description{
This function generates a plot displaying both the marginal density and individual mixture
component densities for univariate constrained mixture of generalized normal distribution (CMGND) models.
It visually represents how the different components of the mixture model contribute to the overall density.
}
\details{
The function plots the overall (marginal) density curve for the CMGND model, as well as the density curves of each mixture component.
This visualization helps in understanding how each component contributes to the model and provides insights into the data distribution.
}
\seealso{
`cmgnd()` for estimating the model parameters.
}
