% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorterMapping.R
\name{sorterMapping}
\alias{sorterMapping}
\title{Cluster Sorters in Concept Mapping Data}
\usage{
sorterMapping(
  CMData,
  numberOfSorterClusters = "auto",
  verbose = TRUE,
  rangeNumberOfClusters = 2:15,
  graph = TRUE
)
}
\arguments{
\item{CMData}{A data frame containing concept mapping data. It must include the columns:
\code{"sorterID"}, \code{"statement"}, and \code{"stackID"}.}

\item{numberOfSorterClusters}{Either a character string (\code{"auto"}) to automatically determine
the optimal number of clusters or an integer specifying the desired number of clusters.}

\item{verbose}{Logical, if \code{TRUE}, additional information about the processing steps is printed to the console.}

\item{rangeNumberOfClusters}{A vector of integers specifying the range of clusters to evaluate
when \cr \code{numberOfSorterClusters = "auto"}. Default is \code{2:15}.}

\item{graph}{Logical. If \code{TRUE}, plots the dendrogram and silhouette method results. Default is \code{TRUE}.}
}
\value{
A list of data frames, each representing the concept mapping data for a cluster of sorters.
If only one cluster is found, the original \code{CMData} is returned.
}
\description{
This function performs clustering of sorters in concept mapping data
based on their sorting behavior. It uses hierarchical clustering and allows
the automatic determination of the optimal number of clusters or a user-defined number.
}
\details{
This function clusters sorters based on their sorting behavior using hierarchical clustering
with Ward's method. If \code{numberOfSorterClusters = "auto"}, the silhouette method is used
to determine the optimal number of clusters within the range specified by \code{rangeNumberOfClusters}.

Each cluster's data is validated for its suitability for concept mapping, and cluster-specific data
is returned as a list of data frames. Graphical output includes a dendrogram and silhouette plot
if \code{graph = TRUE}.
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Subject the data to sorter cluster analysis with a predefined number of sorter clusters
myCMDataBySorters <- sorterMapping(myCMData, numberOfSorterClusters=2)

}
