% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_smooths}
\alias{plot_smooths}
\title{plot_smooths}
\usage{
plot_smooths(
  data,
  fits = NULL,
  max.data = 1e+05,
  select.data = NULL,
  group = "group",
  ...
)
}
\arguments{
\item{data}{The data. If after \code{clustra} run, it includes resulting clusters as group.}

\item{fits}{The \code{tps} component of \code{clustra} output or internal \code{start_groups} fits.
If fits are supplied and \code{select.data} is NULL, the data is colored by
clusters. If NULL, or if \code{select.data} is not NULL, the data is black points.}

\item{max.data}{The maximum number of data points to plot. If zero,
no points are plotted (overrides select.data). Use \code{Inf} value to plot all
points.}

\item{select.data}{Either NULL or a list of length k, each element a data.frame (like data)
with time and response components. The select.data points will be
highlighted with cluster colors on the plot. This is used internally in the
\code{start_groups} function to show the selected starting points. In this case,
also the \code{fits} parameter can contain TPS fits to the starting points.}

\item{group}{Character variable name in \code{data} to color the clusters. A NULL will produce
a b&w point plot.}

\item{...}{Other parameters to \code{plot} function, such as \code{xlim} or \code{ylim} axis limits.}
}
\description{
Plots data and smooths from \code{clustra} output or internally from within
\code{start_groups()}
}
