% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regtestrel.R
\name{regtestrel}
\alias{regtestrel}
\title{Regression-based Measures of Deviation.}
\usage{
regtestrel(x, y)
}
\arguments{
\item{x}{price vector (1 x n).}

\item{y}{value vector (1 x n).}
}
\value{
A list with the following elements:
\item{a0lg}{Intercept in the log-log regression}
\item{a1lg}{Slope in the log-log regression}
\item{r2lg}{R-squared in the log-log regression}
\item{fstatlg}{F-stat of the null hypothesis that a0=0 and a1=1 in the log-log regression}
\item{pvallg}{P-value of the null hypothesis that a0=0 and a1=1 in the log-log regression}
\item{nlg}{Number of observations in the log-log regression}
\item{a0lv}{Intercept in the level-level regression}
\item{a1lv}{Slope in the level-level regression}
\item{r2lv}{R-squared in the level-level regression}
\item{fstatlv}{F-stat of the null hypothesis that a0=0 and a1=1 in the level-level regression}
\item{pvallv}{P-value of the null hypothesis that a0=0 and a1=1 in the level-level regression}
\item{nlv}{Number of observations in the level-level regression}
}
\description{
This function computes various regression based measures of deviation between the vector of all possible relative labor values and the vector of all possible relative prices of production. It runs a log-log and a level-level regression of relative prices on relative values and tests the joint null hypothesis that the intercept is 0 and the slope is 1.
}
\examples{


# Input-output matrix
A <- matrix(
data = c(0.265,0.968,0.00681,0.0121,0.391,0.0169,0.0408,0.808,0.165),
nrow=3, ncol=3, byrow = TRUE
)
# Direct labor input vector (complex)
l <- matrix(
data = c(0.193, 3.562, 0.616),
nrow=1
)
# Real wage bundle
b <- matrix(
data = c(0.0109, 0.0275, 0.296),
ncol=1
)
# Gross output vector
Q <- matrix(
data = c(26530, 18168, 73840),
ncol=1
)
# Direct labor input vector (simple)
l_simple <- l
# Market price vector
m <- matrix(data = c(4, 60, 7),nrow=1)
# Uniform nominal wage rate
wavg <- m\%*\%b
# Vector of nominal wage rates
w <- matrix(data=rep(wavg,3),nrow=1)
# Value of labor power
v <- 2/3
# Compute prices of production using NI
ni1 <- ppnewint1(A = A,l = l,w = wavg[1,1],v=v,Q = Q,l_simple = l)
# Regression-based measures of deviation
regtestrel(x=ni1$ppabs,y=ni1$lvalues)
}
\references{
Basu, Deepankar and Moraitis, Athanasios, "Alternative Approaches to Labor Values andPrices of Production: Theory and Evidence" (2023). Economics Department Working Paper Series. 347. URL: https://scholarworks.umass.edu/econ_workingpaper/347/
}
