% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTrees.R
\name{simMut}
\alias{simMut}
\title{Simulate mutation-based birth and death branching trees}
\usage{
simMut(
  a,
  b,
  cloneAge,
  n,
  nu,
  nTrees = 1,
  precBits = 1000,
  addStem = FALSE,
  nCores = 1
)
}
\arguments{
\item{a}{Birth rate}

\item{b}{Death rate}

\item{cloneAge}{Clone age. Make sure it's same time units as birth and death
rates}

\item{n}{Number of samples/tips of the tree to be returned}

\item{nu}{Mutation rate in units of mutations per unit time. Make sure time
units are consistent with birth and death rates and cloneAge}

\item{nTrees}{Integer indicating the number of trees to generate. Default is
1.}

\item{precBits}{Rmpfr param for handling high precision numbers. Needed to
draw coalescence times.}

\item{addStem}{Boolean indicating whether to add stem to tree preceding first
split/coalescence}

\item{nCores}{Integer indicating the number of cores to use if parallel pkg
is installed. Default is 1.}
}
\value{
An ape object of class "phylo" representing the ultrametric
phylogenetic tree with edge lengths in units of time. Tree metadata is
located in the 'metadata' data.frame included in each "phylo" object. If
'nTrees' param is greater than 1, simUltra returns a list of objects of
such objects of class "phylo".
}
\description{
Generates a sampled tree (or a list of many sampled trees) from
a supercritial (birth rate > death rate) birth and death branching process
according to the coalescent point process described in "Lambert, A. The
coalescent of a sample from a binary branching process. (2018)." Edge
lengths will be in units of mutations, assuming poissonian mutation
accumulation. Essentially a wrapper combining simUltra() and ultra2mut()
functions into one step.
}
\examples{
# Generate a single mutation-based tree with a specified mutation rate
tree <- simMut(a = 1, b = 0.5, cloneAge = 40, n = 50, nu = 10)

# Generate a list of mutation-based trees with a range of mutation rates
tree_list <- simMut(
  a = 1, b = 0.5, cloneAge = 40, n = 50,
  nu = stats::runif(n = 3, min = 10, max = 20), nTrees = 3
)

}
