% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extract_acf}
\alias{extract_acf}
\title{Extract ACF values from clmstan object}
\usage{
extract_acf(object, pars = NULL, lags = 20, ...)
}
\arguments{
\item{object}{A clmstan object}

\item{pars}{Character vector of parameter names. If NULL (default), uses
beta, c_transformed (except first), and beta0.}

\item{lags}{Maximum number of lags to compute. Default is 20.}

\item{...}{Additional arguments (ignored)}
}
\value{
A data frame with columns:
\itemize{
\item parameter: Parameter name
\item chain: Chain number
\item lag: Lag value (0, 1, 2, ...)
\item acf: Autocorrelation value
}
}
\description{
Computes autocorrelation function (ACF) values for MCMC chains and returns
them in a tidy data frame format.
}
\details{
The ACF measures how correlated each draw is with previous draws in the
same chain. High autocorrelation at many lags indicates slow mixing and
the need for more samples or reparameterization.

Ideally, ACF should drop to near zero within a few lags. Persistent
high autocorrelation suggests the sampler is exploring the posterior
slowly.
}
\examples{
\dontrun{
fit <- clm_stan(rating ~ temp, data = wine)
acf_df <- extract_acf(fit)
head(acf_df)

# Plot ACF for specific parameters
library(ggplot2)
acf_df |>
  dplyr::filter(parameter == "beta[1]") |>
  ggplot(aes(x = lag, y = acf, color = factor(chain))) +
  geom_line() +
  geom_hline(yintercept = 0, linetype = "dashed")
}

}
