\name{years_pe_algorithm}
\alias{years_pe_algorithm}
\title{
YEARS Algorithm for Pulmonary Embolism (PE)
}
\description{
Implements the YEARS algorithm to rule out pulmonary embolism in hemodynamically stable patients. This algorithm uses three clinical criteria combined with D-dimer levels to adjust the D-dimer threshold for ruling out PE, potentially reducing the need for CT pulmonary angiography (CTPA).
}
\usage{
years_pe_algorithm(clinical_signs_dvt, hemoptysis, pe_most_likely,
                   d_dimer_level, d_dimer_units = "ng/mL")
}
\arguments{
  \item{clinical_signs_dvt}{
Numeric (0 or 1). Clinical signs of deep vein thrombosis (e.g., swelling, edema). (1 = Yes).
}
  \item{hemoptysis}{
Numeric (0 or 1). Presence of hemoptysis. (1 = Yes).
}
  \item{pe_most_likely}{
Numeric (0 or 1). Is Pulmonary Embolism the most likely diagnosis? (1 = Yes).
}
  \item{d_dimer_level}{
Numeric. D-dimer level. Assumed to be in Fibrinogen Equivalent Units (FEU).
}
  \item{d_dimer_units}{
String. Units for D-dimer input. "ng/mL" (default) or "ug/mL" (or "mg/L").
}
}
\details{
The algorithm logic is as follows:
\itemize{
  \item If 0 YEARS criteria are present: PE is ruled out if D-dimer < 1000 ng/mL.
  \item If >= 1 YEARS criteria are present: PE is ruled out if D-dimer < 500 ng/mL.
}
If the D-dimer level is above the specific threshold, CTPA is indicated.
}
\value{
A list containing:
\item{Result}{"PE Ruled Out" or "CTPA Indicated".}
\item{YEARS_Items_Met}{The count of positive clinical criteria (0-3).}
\item{D_Dimer_Threshold_Used}{The specific D-dimer cutoff used for the evaluation (500 or 1000).}
}
\references{
van der Hulle T, Cheung WY, Kooij S, et al. Simplified diagnostic management of suspected pulmonary embolism (the YEARS study): a prospective, multicentre, cohort study. Lancet. 2017;390(10091):289-297. doi:10.1016/S0140-6736(17)30885-1
}
\examples{
# Example 1: 0 Criteria, High D-dimer (Rule Out due to high threshold)
# No signs, No hemoptysis, PE not most likely, D-dimer 800
# Threshold = 1000. 800 < 1000 -> Ruled Out.
years_pe_algorithm(0, 0, 0, 800)

# Example 2: 1 Criteria, Moderate D-dimer (CTPA Indicated)
# PE most likely (1), D-dimer 600
# Threshold = 500. 600 >= 500 -> CTPA Indicated.
years_pe_algorithm(0, 0, 1, 600)
}
