\name{wisconsin_maxillofacial_criteria}
\alias{wisconsin_maxillofacial_criteria}
\title{
Wisconsin Criteria for Maxillofacial CT Imaging
}
\description{
Calculates the Wisconsin Criteria to determine the need for maxillofacial CT imaging in patients with facial trauma. The presence of any one of the five criteria suggests a higher risk of facial fracture and indicates the need for imaging.
}
\usage{
wisconsin_maxillofacial_criteria(bony_stepoff_instability, periorbital_swelling,
                                 gcs_score, malocclusion, tooth_absence)
}
\arguments{
  \item{bony_stepoff_instability}{
Numeric (0 or 1). Presence of bony step-off or instability of the facial bones. (1 = Yes).
}
  \item{periorbital_swelling}{
Numeric (0 or 1). Presence of periorbital swelling or contusion. (1 = Yes).
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score (3-15). A score < 14 is considered a positive criterion.
}
  \item{malocclusion}{
Numeric (0 or 1). Presence of malocclusion (misalignment of teeth). (1 = Yes).
}
  \item{tooth_absence}{
Numeric (0 or 1). Absence of a tooth (avulsion) secondary to trauma. (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for CT imaging.}
\item{Criteria_Met}{Boolean indicating if any risk factor is present.}
}
\references{
Sitzman TJ, Hanson SE, Al-Sheikhi N, et al. Clinical criteria for obtaining maxillofacial computed tomography in trauma patients. Plast Reconstr Surg. 2011;127(3):1270-1278. doi:10.1097/PRS.0b013e318205f2e0
}
\examples{

# Example 1: Imaging Indicated
# Patient has periorbital swelling (1) and GCS 15
wisconsin_maxillofacial_criteria(0, 1, 15, 0, 0)

# Example 2: Imaging Not Indicated
# No findings, GCS 15
wisconsin_maxillofacial_criteria(0, 0, 15, 0, 0)
}
