\name{ucsf_capra_score}
\alias{ucsf_capra_score}
\title{
UCSF CAPRA Score for Prostate Cancer Risk
}
\description{
Calculates the UCSF CAPRA (Cancer of the Prostate Risk Assessment) Score to predict pathological outcomes and recurrence-free survival after radical prostatectomy. The score utilizes preoperative PSA, Gleason score, clinical T stage, percent positive biopsy cores, and age.
}
\usage{
ucsf_capra_score(psa, gleason_primary, gleason_secondary, clinical_t_stage,
                 percent_positive_cores, age)
}
\arguments{
  \item{psa}{
Numeric. Preoperative PSA level in ng/mL.
}
  \item{gleason_primary}{
Numeric. The primary Gleason pattern (1-5).
}
  \item{gleason_secondary}{
Numeric. The secondary Gleason pattern (1-5).
}
  \item{clinical_t_stage}{
String. Clinical T stage.
"t1" or "t2": 0 points.
"t3a": 1 point.
}
  \item{percent_positive_cores}{
Numeric. Percentage of biopsy cores positive for cancer (0-100).
}
  \item{age}{
Numeric. Patient age in years.
}
}
\value{
A list containing:
\item{CAPRA_Score}{The calculated total score (Range 0-10).}
\item{Risk_Category}{Risk classification (Low: 0-2, Intermediate: 3-5, High: 6-10).}
\item{Est_5_Year_Recurrence_Free_Survival}{Estimated percentage of patients recurrence-free at 5 years post-prostatectomy.}
}
\references{
Cooperberg MR, Pasta DJ, Elkin EP, et al. The University of California, San Francisco Cancer of the Prostate Risk Assessment score: a straightforward and reliable preoperative predictor of disease recurrence after radical prostatectomy. J Urol. 2005;173(6):1938-1942. doi:10.1097/01.ju.0000158155.33890.e7
}
\examples{

# Example 1: Low Risk
# PSA 5, Gleason 3+3, T1c, 20% cores, Age 45
# Score = 0
ucsf_capra_score(5, 3, 3, "t1", 20, 45)

# Example 2: High Risk
# PSA 25, Gleason 4+3, T3a, 50% cores, Age 65
# Score = 3(PSA) + 3(Gleason) + 1(Stage) + 1(Cores) + 1(Age) = 9
ucsf_capra_score(25, 4, 3, "t3a", 50, 65)
}
