\name{triss_trauma_score}
\alias{triss_trauma_score}
\title{
Trauma Score - Injury Severity Score (TRISS)
}
\description{
Calculates the probability of survival for a trauma patient using the TRISS methodology. This method combines anatomical injury severity (ISS), physiological status (Revised Trauma Score), patient age, and the mechanism of injury to estimate outcomes.
}
\usage{
triss_trauma_score(age, mechanism, gcs, systolic_bp, respiratory_rate, iss)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{mechanism}{
String. Mechanism of injury. Options: "blunt" or "penetrating".
}
  \item{gcs}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{iss}{
Numeric. Injury Severity Score (Range 1-75).
}
}
\details{
The Revised Trauma Score (RTS) is calculated first using coded values for GCS, SBP, and RR with standard weights:
\deqn{RTS = 0.9368 \times GCS_c + 0.7326 \times SBP_c + 0.2908 \times RR_c}
The probability of survival (\eqn{P_s}) is then calculated using logistic regression coefficients derived from the Major Trauma Outcome Study (MTOS):
\deqn{P_s = \frac{1}{1 + e^{-b}}}
\deqn{b = b_0 + b_1(RTS) + b_2(ISS) + b_3(AgeIndex)}
Where AgeIndex is 1 if Age >= 55, else 0. Coefficients vary by mechanism (Blunt vs. Penetrating).
}
\value{
A list containing:
\item{TRISS_Probability_Survival}{Estimated percentage probability of survival.}
\item{RTS_Calculated}{The calculated Revised Trauma Score used in the model.}
}
\references{
Boyd CR, Tolson MA, Copes WS. Evaluating trauma care: the TRISS method. Trauma Score and the Injury Severity Score. J Trauma. 1987;27(4):370-378.
Champion HR, Sacco WJ, Copes WS, et al. A revision of the Trauma Score. J Trauma. 1989;29(5):623-629.
}
\examples{

# Example 1: Blunt Trauma, Young, Stable
# Age 30, Blunt, GCS 15, SBP 120, RR 18, ISS 15
triss_trauma_score(30, "blunt", 15, 120, 18, 15)

# Example 2: Penetrating Trauma, Older, Unstable
# Age 60, Penetrating, GCS 10, SBP 85, RR 32, ISS 30
triss_trauma_score(60, "penetrating", 10, 85, 32, 30)
}
