\name{thrive_stroke_score}
\alias{thrive_stroke_score}
\title{
THRIVE Score for Stroke Outcome
}
\description{
Calculates the Totaled Health Risks in Vascular Events (THRIVE) score to predict clinical outcomes (functional independence and mortality) at 90 days in patients with acute ischemic stroke. The score integrates stroke severity (NIHSS), age, and chronic medical conditions (hypertension, diabetes, atrial fibrillation).
}
\usage{
thrive_stroke_score(nihss_score, age, history_hypertension, history_diabetes,
                    history_atrial_fibrillation)
}
\arguments{
  \item{nihss_score}{
Numeric. National Institutes of Health Stroke Scale score (0-42).
0-5: 0 pts.
6-10: 2 pts.
11-20: 4 pts.
>20: 7 pts.
}
  \item{age}{
Numeric. Patient age in years.
18-59: 0 pts.
60-79: 1 pt.
>=80: 2 pts.
}
  \item{history_hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes).
}
  \item{history_diabetes}{
Numeric (0 or 1). History of diabetes mellitus. (1 = Yes).
}
  \item{history_atrial_fibrillation}{
Numeric (0 or 1). History of atrial fibrillation. (1 = Yes).
Note: Presence of ANY chronic disease (HTN, DM, or AF) adds 1 point total.
}
}
\value{
A list containing:
\item{THRIVE_Score}{The calculated total score (Range 0-10).}
\item{Good_Outcome_Probability_90d}{Estimated probability of a good neurological outcome (mRS 0-2).}
\item{Mortality_Risk_90d}{Estimated risk of death within 90 days.}
}
\references{
Flint AC, Cullen SP, Faigeles BS, Rao VA. Predicting long-term outcome after endovascular stroke treatment: the THRIVE score. Stroke. 2010;41(8):1792-1796. doi:10.1161/STROKEAHA.110.588277
}
\examples{

# Example 1: Good Outcome Likely
# NIHSS 4 (0), Age 55 (0), No comorbidities (0)
# Score = 0
thrive_stroke_score(4, 55, 0, 0, 0)

# Example 2: Poor Outcome Likely
# NIHSS 22 (7), Age 82 (2), HTN and AFib (1)
# Score = 10
thrive_stroke_score(22, 82, 1, 0, 1)
}
