\name{rome_iv_child_functional_abdominal_pain}
\alias{rome_iv_child_functional_abdominal_pain}
\title{
Rome IV Diagnostic Criteria for Child Functional Abdominal Pain - NOS
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Functional Abdominal Pain - Not Otherwise Specified (NOS)** in children and adolescents. This diagnosis is made when chronic or recurrent abdominal pain does not meet the full criteria for other specific functional abdominal pain disorders (e.g., IBS, Functional Dyspepsia, Abdominal Migraine).
}
\usage{
rome_iv_child_functional_abdominal_pain(episodes_ge_4_days_month,
                                        pain_localizes_to_periumbilical,
                                        pain_associated_with_defecation,
                                        loss_of_social_functioning,
                                        intermittent_pain_free_periods,
                                        no_organic_causes)
}
\arguments{
  \item{episodes_ge_4_days_month}{
Numeric (0 or 1). Recurrent abdominal pain occurring at least **4 days per month**. (1 = Yes).
}
  \item{pain_localizes_to_periumbilical}{
Numeric (0 or 1). Pain that **localizes to the periumbilical** area. (1 = Yes).
}
  \item{pain_associated_with_defecation}{
Numeric (0 or 1). Pain that is **NOT consistently associated with defecation** or does not meet criteria for another functional abdominal pain disorder. (1 = Associated/Meets other criteria). The **diagnosis requires the absence of this association**.
}
  \item{loss_of_social_functioning}{
Numeric (0 or 1). Pain associated with some loss of **social functioning**. (1 = Yes).
}
  \item{intermittent_pain_free_periods}{
Numeric (0 or 1). Presence of **intermittent pain-free periods**. (1 = Yes).
}
  \item{no_organic_causes}{
Numeric (0 or 1). After appropriate medical evaluation, are symptoms **NOT fully explained by another medical condition**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Abdominal Pain - NOS" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# Pain >4 days/mo, Periumbilical, NOT associated with defecation (0),
#Social impact, Pain-free periods, No organic cause
rome_iv_child_functional_abdominal_pain(1, 1, 0, 1, 1, 1)

# Example 2: Not Met (Associated with Defecation)
# Pain >4 days/mo, Periumbilical, Associated with defecation (1)
rome_iv_child_functional_abdominal_pain(1, 1, 1, 1, 1, 1)
}
